/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.service.rpc.msg;

import com.jme3.network.AbstractMessage;
import com.jme3.network.serializing.Serializable;
import com.jme3.network.serializing.Serializer;
import java.io.PrintWriter;
import java.io.StringWriter;

@Serializable
public class RpcResponseMessage
extends AbstractMessage {
    private long msgId;
    private Object result;
    private String error;
    private Object exception;

    public RpcResponseMessage() {
    }

    public RpcResponseMessage(long msgId, Object result) {
        this.msgId = msgId;
        this.result = result;
    }

    public RpcResponseMessage(long msgId, Throwable t) {
        this.msgId = msgId;
        if (RpcResponseMessage.isSerializable(t)) {
            this.exception = t;
        } else {
            StringWriter sOut = new StringWriter();
            PrintWriter out = new PrintWriter(sOut);
            t.printStackTrace(out);
            out.close();
            this.error = sOut.toString();
        }
    }

    public static boolean isSerializable(Throwable error) {
        if (error == null) {
            return false;
        }
        for (Throwable t = error; t != null; t = t.getCause()) {
            if (Serializer.getExactSerializerRegistration(t.getClass()) != null) continue;
            return false;
        }
        return true;
    }

    public long getMessageId() {
        return this.msgId;
    }

    public Object getResult() {
        return this.result;
    }

    public String getError() {
        return this.error;
    }

    public Throwable getThrowable() {
        return (Throwable)this.exception;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[#" + this.msgId + ", result=" + this.result + (this.error != null ? ", error=" + this.error : "") + (this.exception != null ? ", exception=" + this.exception : "") + "]";
    }
}

