/*
 * Decompiled with CFR 0.152.
 */
package flexjson;

import flexjson.BeanAnalyzer;
import flexjson.DeferredInstantiation;
import flexjson.JSON;
import flexjson.JSONException;
import flexjson.ObjectFactory;
import flexjson.transformer.Transformer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanProperty {
    private final String name;
    private String jsonName;
    private BeanAnalyzer bean;
    private Class propertyType;
    protected final Field property;
    protected Method readMethod;
    protected Method writeMethod;
    protected Map<Class<?>, Method> writeMethods = new HashMap();
    protected DeferredInstantiation<? extends Transformer> transformer = null;
    protected DeferredInstantiation<? extends ObjectFactory> objectFactory = null;
    protected Boolean included = null;

    public BeanProperty(String name, BeanAnalyzer bean) {
        this.name = this.jsonName = name;
        this.bean = bean;
        this.property = bean.getDeclaredField(name);
        if (this.property != null && this.property.isAnnotationPresent(JSON.class)) {
            this.processAnnotation(this.property.getAnnotation(JSON.class));
        }
    }

    public BeanProperty(Field property, BeanAnalyzer bean) {
        this.name = this.jsonName = property.getName();
        this.bean = bean;
        this.property = property;
        this.propertyType = property.getType();
        if (property.isAnnotationPresent(JSON.class)) {
            this.processAnnotation(property.getAnnotation(JSON.class));
        }
    }

    private void processAnnotation(JSON annotation) {
        this.jsonName = annotation.name().length() > 0 ? annotation.name() : this.name;
        this.transformer = annotation.transformer() == Transformer.class ? null : new DeferredInstantiation<Transformer>(annotation.transformer());
        this.objectFactory = annotation.objectFactory() == ObjectFactory.class ? null : new DeferredInstantiation<ObjectFactory>(annotation.objectFactory());
        this.included = annotation.include();
    }

    public String getName() {
        return this.name;
    }

    public String getJsonName() {
        return this.jsonName;
    }

    public Field getProperty() {
        return this.property;
    }

    public Class getPropertyType() {
        return this.propertyType;
    }

    public Method getReadMethod() {
        if (this.readMethod == null && this.bean.getSuperBean() != null && this.bean.getSuperBean().hasProperty(this.name)) {
            return this.bean.getSuperBean().getProperty(this.name).getReadMethod();
        }
        return this.readMethod;
    }

    public Method getWriteMethod() {
        if (this.writeMethod == null) {
            this.writeMethod = this.writeMethods.get(this.propertyType);
            if (this.writeMethod == null && this.bean.getSuperBean() != null && this.bean.getSuperBean().hasProperty(this.name)) {
                return this.bean.getSuperBean().getProperty(this.name).getWriteMethod();
            }
        }
        return this.writeMethod;
    }

    public Collection<Method> getWriteMethods() {
        return this.writeMethods.values();
    }

    public void addWriteMethod(Method method) {
        Class<?> clazz = method.getParameterTypes()[0];
        if (this.propertyType == null) {
            this.propertyType = clazz;
        }
        this.writeMethods.put(clazz, method);
        method.setAccessible(true);
    }

    public void setReadMethod(Method method) {
        if (this.propertyType == null) {
            this.propertyType = method.getReturnType();
            this.readMethod = method;
            this.readMethod.setAccessible(true);
        } else if (method.getReturnType().isAssignableFrom(this.propertyType)) {
            this.readMethod = method;
            this.readMethod.setAccessible(true);
        }
        if (this.readMethod != null && this.readMethod.isAnnotationPresent(JSON.class)) {
            this.processAnnotation(this.readMethod.getAnnotation(JSON.class));
        }
    }

    public Boolean isIncluded() {
        return this.included;
    }

    public Object getValue(Object instance) {
        try {
            Method rm = this.getReadMethod();
            if (rm != null) {
                return rm.invoke(instance, (Object[])null);
            }
            if (this.property != null) {
                return this.property.get(instance);
            }
            return null;
        }
        catch (InvocationTargetException e) {
            throw new JSONException("Error while reading property " + this.propertyType.getName() + "." + this.name, e);
        }
        catch (IllegalAccessException e) {
            throw new JSONException("Error while reading property " + this.propertyType.getName() + "." + this.name, e);
        }
    }

    public Boolean isReadable() {
        Method rm = this.getReadMethod();
        return rm != null && !Modifier.isStatic(rm.getModifiers()) || this.property != null && !Modifier.isStatic(this.property.getModifiers()) && !Modifier.isTransient(this.property.getModifiers());
    }

    public Boolean isWritable() {
        Method wm = this.getWriteMethod();
        return wm != null || this.property != null && Modifier.isPublic(this.property.getModifiers()) && !Modifier.isTransient(this.property.getModifiers());
    }

    public Boolean isTransient() {
        return this.property != null && Modifier.isTransient(this.property.getModifiers());
    }

    protected boolean isNonProperty() {
        return this.getReadMethod() == null && this.getWriteMethod() == null && !Modifier.isPublic(this.property.getModifiers());
    }

    public Transformer getTransformer() throws InstantiationException, IllegalAccessException {
        return this.transformer != null ? this.transformer.get() : null;
    }

    public ObjectFactory getObjectFactory() throws InstantiationException, IllegalAccessException {
        return this.objectFactory != null ? this.objectFactory.get() : null;
    }
}

