/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.app.SettingsDialog;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.audio.AudioRenderer;
import com.jme3.audio.openal.AL;
import com.jme3.audio.openal.ALAudioRenderer;
import com.jme3.audio.openal.ALC;
import com.jme3.audio.openal.EFX;
import com.jme3.system.AppSettings;
import com.jme3.system.ErrorDialog;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.JmeSystemDelegate;
import com.jme3.system.NativeLibraryLoader;
import com.jme3.system.NullContext;
import com.jme3.util.Screenshots;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.swing.SwingUtilities;

public class JmeDesktopSystem
extends JmeSystemDelegate {
    public URL getPlatformAssetConfigURL() {
        return Thread.currentThread().getContextClassLoader().getResource("com/jme3/asset/Desktop.cfg");
    }

    private static BufferedImage verticalFlip(BufferedImage original) {
        AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
        tx.translate(0.0, -original.getHeight());
        AffineTransformOp transformOp = new AffineTransformOp(tx, 1);
        BufferedImage awtImage = new BufferedImage(original.getWidth(), original.getHeight(), 4);
        Graphics2D g2d = awtImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2d.drawImage(original, transformOp, 0, 0);
        g2d.dispose();
        return awtImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeImageFile(OutputStream outStream, String format, ByteBuffer imageData, int width, int height) throws IOException {
        BufferedImage awtImage = new BufferedImage(width, height, 4);
        Screenshots.convertScreenShot2(imageData.asIntBuffer(), awtImage);
        ImageWriter writer = ImageIO.getImageWritersByFormatName(format).next();
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        if (format.equals("jpg")) {
            JPEGImageWriteParam jpegParam = (JPEGImageWriteParam)writeParam;
            jpegParam.setCompressionMode(2);
            jpegParam.setCompressionQuality(0.95f);
        }
        awtImage = JmeDesktopSystem.verticalFlip(awtImage);
        MemoryCacheImageOutputStream imgOut = new MemoryCacheImageOutputStream(outStream);
        writer.setOutput(imgOut);
        IIOImage outputImage = new IIOImage(awtImage, null, null);
        try {
            writer.write(null, outputImage, writeParam);
        }
        finally {
            imgOut.close();
            writer.dispose();
        }
    }

    public void showErrorDialog(String message) {
        if (!GraphicsEnvironment.isHeadless()) {
            final String msg = message;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.showDialog(msg);
                }
            });
        } else {
            System.err.println("[JME ERROR] " + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean showSettingsDialog(AppSettings sourceSettings, final boolean loadFromRegistry) {
        URL iconUrl;
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Cannot run from EDT");
        }
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalStateException("Cannot show dialog in headless environment");
        }
        final AppSettings settings = new AppSettings(false);
        settings.copyFrom(sourceSettings);
        String iconPath = sourceSettings.getSettingsDialogImage();
        if (iconPath == null) {
            iconPath = "";
        }
        if ((iconUrl = JmeSystem.class.getResource(iconPath.startsWith("/") ? iconPath : "/" + iconPath)) == null) {
            throw new AssetNotFoundException(sourceSettings.getSettingsDialogImage());
        }
        final AtomicBoolean done = new AtomicBoolean();
        final AtomicInteger result = new AtomicInteger();
        final Object lock = new Object();
        final SettingsDialog.SelectionListener selectionListener = new SettingsDialog.SelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSelection(int selection) {
                Object object = lock;
                synchronized (object) {
                    done.set(true);
                    result.set(selection);
                    lock.notifyAll();
                }
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    SettingsDialog dialog = new SettingsDialog(settings, iconUrl, loadFromRegistry);
                    dialog.setSelectionListener(selectionListener);
                    dialog.showDialog();
                }
            }
        });
        Object object = lock;
        synchronized (object) {
            while (!done.get()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        sourceSettings.copyFrom(settings);
        return result.get() == 1;
    }

    private JmeContext newContextLwjgl(AppSettings settings, JmeContext.Type type) {
        try {
            Class<?> ctxClazz = null;
            switch (type) {
                case Canvas: {
                    ctxClazz = Class.forName("com.jme3.system.lwjgl.LwjglCanvas");
                    break;
                }
                case Display: {
                    ctxClazz = Class.forName("com.jme3.system.lwjgl.LwjglDisplay");
                    break;
                }
                case OffscreenSurface: {
                    ctxClazz = Class.forName("com.jme3.system.lwjgl.LwjglOffscreenBuffer");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported context type " + type);
                }
            }
            return (JmeContext)ctxClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            this.logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        catch (ClassNotFoundException ex) {
            this.logger.log(Level.SEVERE, "CRITICAL ERROR: Context class is missing!\nMake sure jme3_lwjgl-ogl is on the classpath.", ex);
        }
        return null;
    }

    private JmeContext newContextJogl(AppSettings settings, JmeContext.Type type) {
        try {
            Class<?> ctxClazz = null;
            switch (type) {
                case Display: {
                    ctxClazz = Class.forName("com.jme3.system.jogl.JoglNewtDisplay");
                    break;
                }
                case Canvas: {
                    ctxClazz = Class.forName("com.jme3.system.jogl.JoglNewtCanvas");
                    break;
                }
                case OffscreenSurface: {
                    ctxClazz = Class.forName("com.jme3.system.jogl.JoglOffscreenBuffer");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported context type " + type);
                }
            }
            return (JmeContext)ctxClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            this.logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        catch (ClassNotFoundException ex) {
            this.logger.log(Level.SEVERE, "CRITICAL ERROR: Context class is missing!\nMake sure jme3-jogl is on the classpath.", ex);
        }
        return null;
    }

    private JmeContext newContextCustom(AppSettings settings, JmeContext.Type type) {
        try {
            String className = settings.getRenderer().substring("CUSTOM".length());
            Class<?> ctxClazz = Class.forName(className);
            return (JmeContext)ctxClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            this.logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        catch (ClassNotFoundException ex) {
            this.logger.log(Level.SEVERE, "CRITICAL ERROR: Context class is missing!", ex);
        }
        return null;
    }

    public JmeContext newContext(AppSettings settings, JmeContext.Type contextType) {
        NullContext ctx;
        this.initialize(settings);
        if (settings.getRenderer() == null || settings.getRenderer().equals("NULL") || contextType == JmeContext.Type.Headless) {
            ctx = new NullContext();
            ctx.setSettings(settings);
        } else if (settings.getRenderer().startsWith("LWJGL")) {
            ctx = this.newContextLwjgl(settings, contextType);
            ctx.setSettings(settings);
        } else if (settings.getRenderer().startsWith("JOGL")) {
            ctx = this.newContextJogl(settings, contextType);
            ctx.setSettings(settings);
        } else if (settings.getRenderer().startsWith("CUSTOM")) {
            ctx = this.newContextCustom(settings, contextType);
            ctx.setSettings(settings);
        } else {
            throw new UnsupportedOperationException("Unrecognizable renderer specified: " + settings.getRenderer());
        }
        return ctx;
    }

    private <T> T newObject(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (T)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            this.logger.log(Level.SEVERE, "CRITICAL ERROR: Audio implementation class " + className + " is missing!\n", ex);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            this.logger.log(Level.SEVERE, "Failed to create context", ex);
        }
        return null;
    }

    public AudioRenderer newAudioRenderer(AppSettings settings) {
        EFX efx;
        ALC alc;
        AL al;
        this.initialize(settings);
        if (settings.getAudioRenderer().startsWith("LWJGL")) {
            al = (AL)this.newObject("com.jme3.audio.lwjgl.LwjglAL");
            alc = (ALC)this.newObject("com.jme3.audio.lwjgl.LwjglALC");
            efx = (EFX)this.newObject("com.jme3.audio.lwjgl.LwjglEFX");
        } else if (settings.getAudioRenderer().startsWith("JOAL")) {
            al = (AL)this.newObject("com.jme3.audio.joal.JoalAL");
            alc = (ALC)this.newObject("com.jme3.audio.joal.JoalALC");
            efx = (EFX)this.newObject("com.jme3.audio.joal.JoalEFX");
        } else {
            throw new UnsupportedOperationException("Unrecognizable audio renderer specified: " + settings.getAudioRenderer());
        }
        if (al == null || alc == null || efx == null) {
            return null;
        }
        return new ALAudioRenderer(al, alc, efx);
    }

    public void initialize(AppSettings settings) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.logger.log(Level.INFO, this.getBuildInfo());
        if (!this.lowPermissions && NativeLibraryLoader.isUsingNativeBullet()) {
            NativeLibraryLoader.loadNativeLibrary("bulletjme", true);
        }
    }

    public void showSoftKeyboard(boolean show) {
    }
}

