/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.applicationcontrol;

import com.hybridlab.hyve3d.applicationcontrol.ApplicationControlSession;
import com.hybridlab.hyve3d.applicationcontrol.ApplicationControlSessionObserver;
import com.hybridlab.hyve3d.applicationcontrol.SpiderMonkeyBasedApplicationControlClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationControlClient {
    private static final Logger logger = Logger.getLogger(ApplicationControlClient.class.getSimpleName());
    private List<ApplicationControlSessionObserver> sessionObserver = new ArrayList<ApplicationControlSessionObserver>();
    private SpiderMonkeyBasedApplicationControlClient clientInstance = new SpiderMonkeyBasedApplicationControlClient(this);

    public void onSessionClosed(ApplicationControlSession satelliteSession) {
        logger.log(Level.INFO, "SatelliteSession has been closed: " + satelliteSession);
        for (ApplicationControlSessionObserver obs : this.sessionObserver) {
            obs.onApplicationControlSessionClosed(satelliteSession);
        }
    }

    public void onSessionLost(ApplicationControlSession satelliteSession) {
        logger.log(Level.WARNING, "SatelliteSession lost! : " + satelliteSession);
        for (ApplicationControlSessionObserver obs : this.sessionObserver) {
            obs.onApplicationControlSessionClosed(satelliteSession);
        }
    }

    public void registerSessionObserver(ApplicationControlSessionObserver obs) {
        this.sessionObserver.add(obs);
    }

    void addSession(ApplicationControlSession satelitteSession) {
        logger.log(Level.INFO, "added Session: " + satelitteSession);
        for (ApplicationControlSessionObserver obs : this.sessionObserver) {
            obs.onNewApplicationControlSession(satelitteSession);
        }
    }

    public void connect() throws IOException {
        this.clientInstance.connect();
    }

    public void sendTest() {
        this.clientInstance.sendTest();
    }
}

