/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.applicationcontrol;

import com.hybridlab.hyve3d.applicationcontrol.ApplicationControl;
import com.hybridlab.hyve3d.applicationcontrol.ApplicationControlSession;
import com.hybridlab.hyve3d.applicationcontrol.ApplicationControlSessionObserver;
import com.hybridlab.hyve3d.applicationcontrol.ApplicationControlSessionSetupMessage;
import com.hybridlab.hyve3d.applicationcontrol.FAB8BasedApplicationControlServer;
import com.hybridlab.hyve3d.applicationcontrol.SpiderMonkeyBasedApplicationControlServer;
import com.hybridlab.hyve3d.network.discovery.NetworkServiceManager;
import com.hybridlab.hyve3d.satellitecenter.SatelliteServer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationControlServer {
    private static final Logger logger = Logger.getLogger(ApplicationControlServer.class.getSimpleName());
    public static String defaultAddress = "127.0.0.1";
    public static int defaultPort = 4711;
    private static final ApplicationControl.Transport transport = ApplicationControl.Transport.Spidermonkey;
    private ArrayList<ApplicationControlSession> activeSatelliteSessions = new ArrayList();
    private ArrayList<ApplicationControlSession> inActiveSatelliteSessions = new ArrayList();
    private List<ApplicationControlSessionObserver> sessionObserver = new ArrayList<ApplicationControlSessionObserver>();
    private SatelliteServer.SatelliteClientServerMessageChannel serverInstance;

    public ApplicationControlServer(NetworkServiceManager networkServiceManager) {
        switch (transport) {
            case FAB8: {
                this.serverInstance = new FAB8BasedApplicationControlServer(this, networkServiceManager);
                break;
            }
            case Spidermonkey: {
                this.serverInstance = new SpiderMonkeyBasedApplicationControlServer(this, networkServiceManager);
            }
        }
    }

    public void startListenForConnectionsAndServe() {
        this.serverInstance.start();
    }

    public void shutdown() {
        this.serverInstance.stop();
    }

    public void onSessionClosed(ApplicationControlSession satelliteSession) {
        logger.log(Level.INFO, "SatelliteSession has been closed: " + satelliteSession);
        this.markSessionAsInactive(satelliteSession);
        for (ApplicationControlSessionObserver obs : this.sessionObserver) {
            obs.onApplicationControlSessionClosed(satelliteSession);
        }
    }

    public void onSessionLost(ApplicationControlSession satelliteSession) {
        logger.log(Level.WARNING, "SatelliteSession lost! : " + satelliteSession);
        this.markSessionAsInactive(satelliteSession);
        for (ApplicationControlSessionObserver obs : this.sessionObserver) {
            obs.onApplicationControlSessionClosed(satelliteSession);
        }
    }

    public void registerSessionObserver(ApplicationControlSessionObserver obs) {
        this.sessionObserver.add(obs);
    }

    void addSession(ApplicationControlSession satelitteSession) {
        logger.log(Level.INFO, "added Session: " + satelitteSession);
        this.activeSatelliteSessions.add(satelitteSession);
        for (ApplicationControlSessionObserver obs : this.sessionObserver) {
            obs.onNewApplicationControlSession(satelitteSession);
        }
    }

    void markSessionAsInactive(ApplicationControlSession appCtrlSession) {
        logger.log(Level.INFO, "Session now inactive: " + appCtrlSession);
        this.activeSatelliteSessions.remove(appCtrlSession);
        this.inActiveSatelliteSessions.add(appCtrlSession);
    }

    public ApplicationControlSession createSession() {
        ApplicationControlSession newSession = new ApplicationControlSession(this);
        this.addSession(newSession);
        return newSession;
    }

    public void sessionSetup(ApplicationControlSession satelliteSession, ApplicationControlSessionSetupMessage setup) {
        for (ApplicationControlSessionObserver obs : this.sessionObserver) {
            obs.onApplicationControlSessionSetup(satelliteSession, setup);
        }
    }
}

