/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.applicationcontrol;

import com.hybridlab.hyve3d.applicationcontrol.ApplicationControlClientConnectionListener;
import com.hybridlab.hyve3d.applicationcontrol.ApplicationControlSession;
import com.hybridlab.hyve3d.applicationcontrol.ApplicationControlSessionSetupMessage;
import com.hybridlab.hyve3d.network.messages.AbstractHisMessage;
import com.hybridlab.hyve3d.network.transport.MessageTransportConnection;
import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import com.jme3.network.Server;
import java.io.IOException;
import java.util.logging.Logger;

public class SpiderMonkeyApplicationControlConnection
implements MessageTransportConnection {
    Server serverConnection;
    HostedConnection clientConnection;
    ApplicationControlClientConnectionListener listener;
    Logger logger = Logger.getLogger(SpiderMonkeyApplicationControlConnection.class.getSimpleName());

    public SpiderMonkeyApplicationControlConnection(Server server, HostedConnection conn, ApplicationControlSession listener) {
        this.serverConnection = server;
        this.clientConnection = conn;
        this.listener = listener;
        this.setApplicationControlSessionSetupMessageHandler();
        this.listener.onConnectionEstablished(this);
    }

    private void setApplicationControlSessionSetupMessageHandler() {
        this.serverConnection.addMessageListener((MessageListener)new MessageListener<HostedConnection>(){

            public void messageReceived(HostedConnection source, Message message) {
                SpiderMonkeyApplicationControlConnection.this.listener.onMessageReceived((ApplicationControlSessionSetupMessage)message);
            }
        }, new Class[]{ApplicationControlSessionSetupMessage.class});
    }

    @Override
    public void disconnect() throws IOException {
        this.clientConnection.close("Connection was closed from server side.");
    }

    @Override
    public void send(AbstractHisMessage message) throws MessageTransportConnection.SendFailedException {
        this.clientConnection.send((Message)message);
    }
}

