/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.config;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;

public class ReflectionHelper {
    public static boolean isIterable(Type type) {
        if (type instanceof Class && ReflectionHelper.isIterableClass((Class)type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.isIterable(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && ReflectionHelper.isIterable(upperBounds[0]);
        }
        return false;
    }

    private static boolean isIterableClass(Class<?> clazz) {
        ArrayList classes = new ArrayList();
        ReflectionHelper.computeClassHierarchy(clazz, classes);
        return classes.contains(Iterable.class);
    }

    private static void computeClassHierarchy(Class<?> clazz, List<Class<?>> classes) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            if (classes.contains(current)) {
                return;
            }
            classes.add(current);
            for (Class<?> currentInterface : current.getInterfaces()) {
                ReflectionHelper.computeClassHierarchy(currentInterface, classes);
            }
        }
    }
}

