/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core;

import com.hybridlab.hyve3d.core.StrokeId;
import com.hybridlab.hyve3d.core.StrokeInk;
import com.hybridlab.hyve3d.core.StrokeStatusObserver;
import com.hybridlab.hyve3d.core.StylusPressure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractStroke {
    private long creationMilliseconds = 0L;
    private Set<StrokeStatusObserver> statusObservers = new HashSet<StrokeStatusObserver>(1);
    private StrokeStatus status = StrokeStatus.UNKNOWN;
    protected StrokeId id;
    public StrokeInk ink;
    protected List<StylusPressure> pressures = new ArrayList<StylusPressure>();

    protected List<Float> getAllNormalizedPressures() {
        ArrayList<Float> p = new ArrayList<Float>();
        ArrayList<StylusPressure> pressurecopy = new ArrayList<StylusPressure>(this.pressures);
        for (StylusPressure sp : pressurecopy) {
            p.add(Float.valueOf(sp.getNormalizedValue()));
        }
        return p;
    }

    public void addPressures(short[] pressures) {
        for (short s : pressures) {
            this.pressures.add(new StylusPressure(s));
        }
    }

    public void addPressures(List<StylusPressure> pressures) {
        this.pressures.addAll(pressures);
    }

    public List<StylusPressure> getPressures() {
        return Collections.unmodifiableList(this.pressures);
    }

    public float getAveragePressure() {
        float sum = 0.0f;
        for (StylusPressure p : this.pressures) {
            sum += p.getNormalizedValue();
        }
        return this.pressures.isEmpty() ? -1.0f : sum / (float)this.pressures.size();
    }

    public StrokeInk getInk() {
        return this.ink;
    }

    public void setInk(StrokeInk ink) {
        this.ink = ink;
    }

    public void registerStatusObserver(StrokeStatusObserver o) {
        this.statusObservers.add(o);
    }

    public void unRegisterStatusObserver(StrokeStatusObserver o) {
        this.statusObservers.remove(o);
    }

    public void setStatusWithoutNotifying(StrokeStatus status) {
        this.status = status;
    }

    public void setStatus(StrokeStatus status) {
        StrokeStatus oldstatus = this.status;
        this.status = status;
        if (!oldstatus.equals((Object)this.status) && !this.statusObservers.isEmpty()) {
            switch (this.status) {
                case VISIBLE: {
                    for (StrokeStatusObserver so : this.statusObservers) {
                        so.onVisibilityOfObservedStrokeChanged(this, true);
                    }
                    break;
                }
                case INVISIBLE: {
                    for (StrokeStatusObserver so : this.statusObservers) {
                        so.onVisibilityOfObservedStrokeChanged(this, false);
                    }
                    break;
                }
                case ERASED: {
                    for (StrokeStatusObserver so : this.statusObservers) {
                        so.onObservedStrokeErased(this);
                    }
                    break;
                }
            }
        }
    }

    public StrokeId getStrokeId() {
        return this.id;
    }

    public void setStrokeId(StrokeId id) {
        this.id = id;
    }

    public long getCreationMilliseconds() {
        return this.creationMilliseconds;
    }

    public void setCreationMilliseconds(long creationMilliseconds) {
        this.creationMilliseconds = creationMilliseconds;
    }

    public static enum StrokeStatus {
        UNKNOWN,
        VISIBLE,
        INVISIBLE,
        ERASED;

    }
}

