/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core;

import com.hybridlab.hyve3d.constants.Constants;
import com.hybridlab.hyve3d.core.CamRigPositionAndRotationListener;
import com.hybridlab.hyve3d.core.DrawingAreaBookmark;
import com.hybridlab.hyve3d.core.DrawingAreaStateMemento;
import com.hybridlab.hyve3d.core.DrawingAreaTransformation;
import com.hybridlab.hyve3d.core.DrawingAreaVisualization;
import com.hybridlab.hyve3d.core.FrameRect;
import com.hybridlab.hyve3d.core.His2DCanvas;
import com.hybridlab.hyve3d.core.His3DCanvas;
import com.hybridlab.hyve3d.core.His3DScene;
import com.hybridlab.hyve3d.core.HisDrawingAreaListener;
import com.hybridlab.hyve3d.core.Satellite;
import com.hybridlab.hyve3d.core.Stroke2D;
import com.hybridlab.hyve3d.core.Stroke3D;
import com.hybridlab.hyve3d.core.Stroke3DPoint;
import com.hybridlab.hyve3d.core.StrokeId;
import com.hybridlab.hyve3d.core.StrokeInk;
import com.hybridlab.hyve3d.core.StrokeInputCapturer;
import com.hybridlab.hyve3d.core.StylusPressure;
import com.hybridlab.hyve3d.core.TabletDevice;
import com.hybridlab.hyve3d.core.TransformationOptions;
import com.hybridlab.hyve3d.core.animation.PositionAndRotationChangeAble;
import com.hybridlab.hyve3d.core.commands.CommandChangeMode;
import com.hybridlab.hyve3d.core.commands.UndoRedoCommand;
import com.hybridlab.hyve3d.core.locations.Compass;
import com.hybridlab.hyve3d.network.interconnection.HisDrawingArea;
import com.hybridlab.hyve3d.network.interconnection.IdeationSpace;
import com.hybridlab.hyve3d.network.messages.DrawAreaTransformStateMessage;
import com.hybridlab.hyve3d.network.messages.FrameRectDefinitionMessage;
import com.hybridlab.hyve3d.network.messages.Move2DMessage;
import com.hybridlab.hyve3d.network.messages.Move3DMessage;
import com.hybridlab.hyve3d.network.messages.Pointing2DTransmissionPartMessage;
import com.hybridlab.hyve3d.network.messages.Stroke2DTransmissionPartMessage;
import com.hybridlab.hyve3d.network.messages.StrokeInkMessage;
import com.hybridlab.hyve3d.network.messages.ZoomMessage;
import com.hybridlab.hyve3d.rendering.projection.SixCameraRig;
import com.hybridlab.utils.ThreePerpendicularAxes;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.network.Client;
import com.jme3.network.ClientStateListener;
import com.jme3.network.Message;
import com.jme3.network.Network;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

public class DrawingArea
implements PositionAndRotationChangeAble,
CamRigPositionAndRotationListener,
Compass.CompassListener,
HisDrawingArea {
    private UUID id;
    private boolean wasMovedSinceLastSketch = false;
    private His2DCanvas currentCanvas2D;
    private DrawingAreaVisualization visualization;
    private His3DScene workingScene;
    private His3DCanvas canvas3D;
    private StrokeInputCapturer strokeInputCapturer;
    private StrokeInk currentStrokeInk = new StrokeInk();
    private Satellite connectedSatellite;
    private Set<HisDrawingAreaListener> listeners = new HashSet<HisDrawingAreaListener>();
    private Map<UUID, Stroke2D> strokes2D = new HashMap<UUID, Stroke2D>();
    private Map<Stroke2D, Stroke3D> strokes3D = new HashMap<Stroke2D, Stroke3D>();
    private Logger logger = Logger.getLogger(DrawingArea.class.getSimpleName());
    private DrawingAreaTransformation transformation = new DrawingAreaTransformation();
    private TransformationOptions daTransformationFilter = new TransformationOptions();
    private final float fastE = (float)Math.E;
    private FrameRect zoomReferenceFrameRect = null;
    private boolean walkingDuringTransformationEnabled = true;
    private DATransformObserver obs;
    private String labelText;
    private UUID ideationSpaceId;
    private IdeationSpace owner;
    private boolean ignoreCamRigUpdates = true;
    private boolean snappingEnabled = Constants.DrawingAreaSnapping.EnabledByDefault;
    private ColorRGBA frameColor = ColorRGBA.LightGray;
    private float snapAngle = 0.2617994f;
    private Quaternion camrigRotation = new Quaternion();
    private DrawingAreaStyle style = DrawingAreaStyle.REGULAR;
    private DrawingAreaTransformation hingeBaseTransformation;

    @Override
    public ColorRGBA getFrameColor() {
        return this.frameColor;
    }

    public void setFrameColor(ColorRGBA frameColor) {
        if (frameColor == null) {
            return;
        }
        if (!frameColor.equals((Object)this.frameColor)) {
            this.frameColor = frameColor;
            for (HisDrawingAreaListener l : this.listeners) {
                l.onFrameColorHasChanged(this);
            }
        }
    }

    private void move(float f) {
        this.transformation.move(f);
        this.visualization.move(f);
        this.wasMovedSinceLastSketch = true;
        this.reAlignCurrrentCanvas2d();
    }

    private void move(Vector2f moveVector) {
        this.transformation.move(moveVector);
        this.visualization.move(moveVector);
        this.wasMovedSinceLastSketch = true;
        this.reAlignCurrrentCanvas2d();
    }

    private void move(Vector3f moveVector) {
        switch (this.daTransformationFilter.transformFilter) {
            default: {
                break;
            }
            case RXYZ_TGXYZ: 
            case TGXYZ: 
            case TGXZ: 
            case TXY: 
            case TZ: 
            case TX: 
            case TY: {
                Vector3f filteredMoveVector = this.transformation.applyFilterToMoveVector(moveVector, this.daTransformationFilter.transformFilter);
                this.visualization.move(filteredMoveVector);
                this.transformation.move(filteredMoveVector);
                this.wasMovedSinceLastSketch = true;
                this.reAlignCurrrentCanvas2d();
                for (HisDrawingAreaListener l : this.listeners) {
                    l.onTransformationHasChanged(this);
                }
            }
        }
    }

    @Override
    public void setRotation(Quaternion rot) {
        switch (this.daTransformationFilter.transformFilter) {
            default: {
                break;
            }
            case HINGE_BOTTOM: 
            case HINGE_TOP: 
            case HINGE_LEFT: 
            case HINGE_RIGHT: 
            case HINGE_CENTER: {
                this.applyHingedRotation(rot, this.daTransformationFilter.transformFilter);
                break;
            }
            case RXYZ_TGXYZ: {
                rot = this.snap(rot);
                this.visualization.setRotation(rot);
                this.transformation.setRotation(rot);
            }
        }
        this.reAlignCurrrentCanvas2d();
        for (HisDrawingAreaListener l : this.listeners) {
            l.onTransformationHasChanged(this);
        }
    }

    private void applyHingedRotation(Quaternion rotationToApply, TransformationOptions.TransformationFilter hingetype) {
        if (this.hingeBaseTransformation != null) {
            Vector3f pos = this.hingeBaseTransformation.getTranslation();
            ThreePerpendicularAxes axes = this.hingeBaseTransformation.getAxesLocal();
            Quaternion rot = this.hingeBaseTransformation.getRotation();
            block0 : switch (hingetype) {
                case HINGE_LEFT: 
                case HINGE_RIGHT: {
                    Vector3f rotationaxis = axes.X;
                    Vector3f zAxis = axes.Z;
                    Vector3f rotatedZAxis = rotationToApply.mult(zAxis);
                    Vector3f alignedYAxis = rotatedZAxis.cross(rotationaxis).normalize();
                    Vector3f alignedZAxis = rotationaxis.cross(alignedYAxis).normalize();
                    Quaternion q = new Quaternion();
                    q.fromAxes(rotationaxis, alignedYAxis, alignedZAxis);
                    this.visualization.setRotation(q);
                    this.transformation.setRotation(q);
                    break;
                }
                case HINGE_CENTER: {
                    Vector3f rotationaxis = axes.Z;
                    Vector3f xAxis = axes.X;
                    Vector3f rotatedXAxis = rotationToApply.mult(xAxis);
                    Vector3f alignedYAxis = rotationaxis.cross(rotatedXAxis).normalize();
                    Vector3f alignedXAxis = alignedYAxis.cross(rotationaxis).normalize();
                    Quaternion q = new Quaternion();
                    q.fromAxes(alignedXAxis, alignedYAxis, rotationaxis);
                    this.visualization.setRotation(q);
                    this.transformation.setRotation(q);
                    break;
                }
                case HINGE_BOTTOM: 
                case HINGE_TOP: {
                    Vector3f rotationaxis = axes.Y;
                    Vector3f zAxis = axes.Z;
                    Vector3f rotatedZAxis = rotationToApply.mult(zAxis);
                    Vector3f alignedXAxis = rotationaxis.cross(rotatedZAxis).normalize();
                    Vector3f alignedZAxis = alignedXAxis.cross(rotationaxis).normalize();
                    Quaternion q = new Quaternion();
                    q.fromAxes(alignedXAxis, rotationaxis, alignedZAxis);
                    this.visualization.setRotation(q);
                    this.transformation.setRotation(q);
                    switch (hingetype) {
                        case HINGE_BOTTOM: {
                            break block0;
                        }
                        case HINGE_TOP: {
                            Vector3f pivotPosition = pos.add(axes.Y).mult(this.hingeBaseTransformation.getFrameRect().getHeight() * -0.5f);
                            Vector3f hingeVector = pos.subtract(pivotPosition);
                            Vector3f hingedVector = q.mult(hingeVector);
                            Vector3f newPosition = pivotPosition.add(hingedVector);
                            this.visualization.setTranslation(newPosition);
                            this.transformation.setTranslation(newPosition);
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
    }

    public void setSnapAngleDeg(float deg) {
        this.snapAngle = deg * ((float)Math.PI / 180);
    }

    public void setSnappingEnabled(boolean enabled) {
        this.snappingEnabled = enabled;
    }

    private Quaternion snap(Quaternion rot) {
        if (!this.snappingEnabled) {
            return rot;
        }
        Vector3f[] axes = new Vector3f[3];
        rot.toAxes(axes);
        Vector3f z = axes[2];
        float angleToGlobalY = z.angleBetween(Vector3f.UNIT_Y);
        if (angleToGlobalY < this.snapAngle) {
            Vector3f x = axes[0];
            x.y = 0.0f;
            x.normalizeLocal();
            Vector3f y = x.cross(Vector3f.UNIT_Y).negate();
            rot = rot.fromAxes(x, y, Vector3f.UNIT_Y);
            return rot;
        }
        if ((float)Math.PI - angleToGlobalY < this.snapAngle) {
            Vector3f x = axes[0];
            x.y = 0.0f;
            x.normalizeLocal();
            Vector3f y = x.cross(Vector3f.UNIT_Y.negate()).negate();
            rot = rot.fromAxes(x, y, Vector3f.UNIT_Y.negate());
            return rot;
        }
        if (Math.abs(angleToGlobalY - 1.5707964f) < this.snapAngle) {
            Vector3f rotationaxis = Vector3f.UNIT_Y.cross(z);
            Quaternion snaprotation = new Quaternion();
            snaprotation.fromAngleAxis(1.5707964f - angleToGlobalY, rotationaxis);
            return snaprotation.mult(rot);
        }
        return rot;
    }

    public void setFrameRect(FrameRect r) {
        this.transformation.setFrameRect(r);
        if (null != this.visualization) {
            this.visualization.setFrameRect(this.transformation.getFrameRect());
        }
        if (null != this.connectedSatellite) {
            this.connectedSatellite.sendMessage(new FrameRectDefinitionMessage(this.transformation.getFrameRect()));
        }
    }

    private Vector3f get3dPositionOfPointOnDrawArea(Vector2f point2d) {
        Vector3f point3d = this.visualization.getScenePositionOfPointOnDrawArea(point2d);
        return point3d;
    }

    private void reAlignCurrrentCanvas2d() {
        this.currentCanvas2D.alignTo(this);
    }

    public His2DCanvas getCurrent2dCanvas() {
        return this.currentCanvas2D;
    }

    private His2DCanvas createAlignedCanvas2D() {
        His2DCanvas c = this.strokeInputCapturer.create2dCanvas();
        c.alignTo(this);
        return c;
    }

    public DrawingArea(StrokeInputCapturer sic, UUID ideationSpaceId) {
        this(sic, UUID.randomUUID(), ideationSpaceId);
    }

    public DrawingArea(StrokeInputCapturer sic, UUID id, UUID ideationSpaceId) {
        this.strokeInputCapturer = sic;
        this.currentCanvas2D = this.createAlignedCanvas2D();
        this.obs = new DATransformObserver(this.transformation);
        this.id = id;
        this.ideationSpaceId = ideationSpaceId;
        this.obs.startObserving();
    }

    public DrawingAreaVisualization getVisualization() {
        return this.visualization;
    }

    public void setVisualization(DrawingAreaVisualization visualization) {
        this.visualization = visualization;
        visualization.setIgnoreCamRigUpdates(this.ignoreCamRigUpdates);
        this.setTabletVisualizationVisibility(false);
        this.visualization.setTranslation(this.transformation.getTranslation().clone());
    }

    public void processMessage(Stroke2DTransmissionPartMessage message) {
        this.strokeInputCapturer.enqueueStroke2DTransmissionPartMessage(message, this);
    }

    public void setWorkingScene(His3DScene workingScene) {
        this.workingScene = workingScene;
        if (null == this.canvas3D) {
            this.canvas3D = this.workingScene.get3dCanvasForDrawingArea(this);
        }
    }

    public void processMessage(Move2DMessage message) {
        Vector2f messageVector = message.getVector();
        float moveScale = 1.0f;
        switch (message.getType()) {
            case THREE_FINGER: {
                Vector3f move = new Vector3f(messageVector.x, 0.0f, messageVector.y).clone().multLocal(moveScale);
                this.move(move);
                break;
            }
            case ONE_FINGER: {
                this.move(messageVector.clone().multLocal(moveScale));
                break;
            }
            case TWO_FINGER: {
                this.move(messageVector.y * moveScale);
                break;
            }
        }
    }

    public void processMessage(Move3DMessage message) {
        Vector3f messageVector = message.getVector();
        switch (message.getType()) {
            case TYPE_ABSOLUTE_DEVICE_ACCELEROMETERBASED_METER: {
                float moveScale_1 = 5.0f * this.transformation.getFrameRect().getDiagonalLength();
                Vector3f move = messageVector.clone().multLocal(moveScale_1);
                this.move(move);
                break;
            }
            case TYPE_RELATIVE_HYDRA_BASED: {
                float base = (float)Math.E;
                float flattenfactor = 0.004f;
                float value = this.transformation.getFrameRect().getDiagonalLength();
                float moveScale_hydra = flattenfactor * FastMath.log((float)(value + 1.0f), (float)base);
                Vector3f move = messageVector.clone().multLocal(moveScale_hydra);
                this.move(move);
                break;
            }
            case TYPE_RELATIVE_LEAPMOTION_BASED: {
                float moveScale_leap = 0.1f * this.transformation.getFrameRect().getDiagonalLength();
                Vector3f move = messageVector.clone().multLocal(moveScale_leap);
                this.move(move);
                break;
            }
        }
    }

    private void move2DCanvas(Vector2f vector2f) {
        Move2DMessage msg = new Move2DMessage(Move2DMessage.Type.RELATIVE, vector2f.clone(), Move2DMessage.State.MOVE);
        this.getConnectedSatellite().sendMessage(msg);
    }

    public void processStroke2DTransmissionPart(Stroke2DTransmissionPartMessage m) {
        StrokeId id = m.getStrokeId();
        Quaternion orientation = this.transformation.getWorldRotation().clone();
        if (this.wasMovedSinceLastSketch) {
            this.reAlignCurrrentCanvas2d();
            this.wasMovedSinceLastSketch = false;
        }
        switch (m.getType()) {
            case COMPLETE: {
                Stroke2D stroke2d = m.createStroke2D();
                this.strokes2D.put(stroke2d.getStrokeId().getUUID(), stroke2d);
                Stroke3D s3d = new Stroke3D(m.getInk());
                s3d.setStrokeId(stroke2d.getStrokeId().duplicate());
                this.strokes3D.put(stroke2d, s3d);
                this.canvas3D.addStroke(s3d);
                Vector2f[] points = stroke2d.getPointsArray();
                List<StylusPressure> pressures = stroke2d.getPressures();
                for (int i = 0; i < points.length; ++i) {
                    Vector2f p = points[i];
                    Vector3f point3d = this.get3dPositionOfPointOnDrawArea(p);
                    s3d.addPoint(Stroke3DPoint.create(point3d, pressures.get(i), i, orientation));
                }
                stroke2d.observeStatusOf(s3d);
                if (this.connectedSatellite == null) break;
                this.connectedSatellite.manageFreshStroke(stroke2d);
                break;
            }
            case BEGIN: {
                Stroke2D stroke2d = m.createStroke2D();
                this.strokes2D.put(stroke2d.getStrokeId().getUUID(), stroke2d);
                Stroke3D s3d = new Stroke3D(this.currentStrokeInk.clone());
                this.strokes3D.put(stroke2d, s3d);
                s3d.setStrokeId(stroke2d.getStrokeId().duplicate());
                List<StylusPressure> pressures2d = stroke2d.getPressures();
                List<Vector2f> points2d = stroke2d.getPoints();
                for (int i = 0; i < points2d.size(); ++i) {
                    StylusPressure pr = null;
                    pr = i > pressures2d.size() - 1 ? StylusPressure.NoPressure : pressures2d.get(i);
                    Vector2f point2d = points2d.get(i);
                    Stroke3DPoint p3d = Stroke3DPoint.create(this.get3dPositionOfPointOnDrawArea(point2d), pr, orientation);
                    s3d.addPoint(p3d);
                }
                this.canvas3D.addStroke(s3d);
                this.visualization.setCursorPointPosition(m.getFirstPoint());
                stroke2d.observeStatusOf(s3d);
                if (this.connectedSatellite == null) break;
                this.connectedSatellite.manageFreshStroke(stroke2d);
                break;
            }
            case ADD: 
            case END: {
                Stroke2D stroke2d = this.strokes2D.get(id.getUUID());
                Stroke3D s3d = this.strokes3D.get(stroke2d);
                if (s3d == null) {
                    throw new NullPointerException("Konnte keinen Stroke3D f\u00fcr einen Stroke2D finden!");
                }
                List<StylusPressure> pressures2d2 = StylusPressure.createPressures(m.getPressures());
                ArrayList<Vector2f> points2d2 = new ArrayList<Vector2f>();
                for (Vector2f p2d : m.getPoints()) {
                    points2d2.add(p2d);
                }
                stroke2d.addPoints(points2d2);
                stroke2d.addPressures(pressures2d2);
                for (int i = 0; i < points2d2.size(); ++i) {
                    StylusPressure pr = null;
                    pr = i > pressures2d2.size() - 1 ? StylusPressure.NoPressure : pressures2d2.get(i);
                    Vector2f point2d = (Vector2f)points2d2.get(i);
                    Stroke3DPoint p3d = Stroke3DPoint.create(this.get3dPositionOfPointOnDrawArea(point2d), pr, orientation);
                    s3d.addPoint(p3d);
                }
                this.visualization.setCursorPointPosition(m.getLastPoint());
                if (!m.getType().equals((Object)Stroke2DTransmissionPartMessage.SubType.END)) break;
                s3d.finish();
                break;
            }
        }
    }

    public void processMessage(Pointing2DTransmissionPartMessage message) {
        Vector2f point2d = message.getFirstPoint();
        this.visualization.setCursorPointPosition(point2d);
    }

    public void processMessage(StrokeInkMessage message) {
        this.currentStrokeInk = StrokeInkMessage.toStrokeInk(message);
    }

    public StrokeInk getCurrentStrokeInk() {
        return this.currentStrokeInk;
    }

    public void setTabletVisualizationVisibility(boolean b) {
        if (null != this.visualization) {
            this.visualization.setTabletVisibility(b);
        }
    }

    public void processMessage(ZoomMessage message) {
        if (null != this.visualization) {
            switch (message.getSt()) {
                case ZOOM_BEGIN: {
                    this.zoomReferenceFrameRect = message.getFrameRect();
                    this.scaleReferenceFrameRectWithZoomFactorAndSet(message.getZoomValue());
                    break;
                }
                case ZOOM_CHANGE: {
                    this.scaleReferenceFrameRectWithZoomFactorAndSet(message.getZoomValue());
                    break;
                }
                case ZOOM_END: {
                    if (!this.scaleReferenceFrameRectWithZoomFactorAndSet(message.getZoomValue())) break;
                    this.zoomReferenceFrameRect = null;
                }
            }
        }
    }

    private boolean scaleReferenceFrameRectWithZoomFactorAndSet(float zoomvalue) {
        if (null != this.zoomReferenceFrameRect) {
            FrameRect zoomedFrameRect = this.zoomReferenceFrameRect.mult(zoomvalue);
            this.setFrameRect(zoomedFrameRect);
            return true;
        }
        return false;
    }

    public void processMessage(FrameRectDefinitionMessage message) {
        throw new RuntimeException();
    }

    public Satellite getConnectedSatellite() {
        return this.connectedSatellite;
    }

    public void setConnectedSatellite(Satellite connectedSatellite) {
        this.connectedSatellite = connectedSatellite;
        this.labelText = connectedSatellite.getName();
    }

    public void onSatelliteModeHasChanged(CommandChangeMode.SatelliteMode newMode) {
    }

    public void setDrawingAreaLabelText(String satelliteName) {
        this.labelText = satelliteName;
        if (null != this.visualization) {
            this.visualization.setDrawAreaLabelText(satelliteName);
        }
    }

    public void setTransformOptions(TransformationOptions options) {
        this.daTransformationFilter = options;
        this.transformation.setFilter(options);
    }

    public TransformationOptions getTransformOptions() {
        return this.transformation.getFilter();
    }

    @Override
    public DrawingAreaTransformation getTransformation() {
        return this.transformation;
    }

    public Vector2f getCurrentCanvas2DShift() {
        return new Vector2f();
    }

    public void performUndoRedoCommand(UndoRedoCommand undoRedoCmd) {
        switch (undoRedoCmd.getTarget()) {
            default: 
        }
        int steps = undoRedoCmd.getSteps();
        for (int i = 1; i <= Math.abs(steps); ++i) {
            if (steps < 0) {
                this.canvas3D.undo();
                continue;
            }
            if (steps <= 0) continue;
            this.canvas3D.redo();
        }
    }

    @Override
    public Vector3f getPosition() {
        return this.transformation.getTranslation();
    }

    @Override
    public void setPosition(Vector3f position) {
        this.transformation.setTranslation(position);
        this.visualization.setTranslation(position);
        this.reAlignCurrrentCanvas2d();
    }

    public boolean isWalkHisCameraDuringDrawAreaTransfomationEnabled() {
        return this.walkingDuringTransformationEnabled;
    }

    @Override
    public Quaternion getRotation() {
        return this.transformation.getRotation();
    }

    @Override
    public void camRigPositionHasChanged(SixCameraRig camRig) {
        this.transformation.setCameraRigWorldPosition(camRig.getWorldTranslation().clone());
        this.visualization.camRigPositionHasChanged(this.transformation.getCameraRigWorldPosition());
    }

    @Override
    public void camRigRotationHasChanged(SixCameraRig camRig) {
        Quaternion r = camRig.getLocalRotation().clone();
        this.transformation.setCamRigRotation(r);
        this.visualization.camRigRotationHasChanged(this.transformation.getCamRigRotation());
        this.camrigRotation = r;
    }

    @Override
    public void compassHeadingHasChanged(Compass compass) {
        this.transformation.setCompassHeadingRotation(compass.getNorthHeadingRotation().clone());
        this.visualization.compassHeadingHasChanged(this.transformation.getCompassHeadingRotation());
    }

    @Override
    public void visibilityHasChanged(Compass compass) {
    }

    public void placeIntoBookmark(DrawingAreaBookmark bookmark) {
        this.setPosition(bookmark.getPosition());
        this.setRotation(bookmark.getRotation());
        this.setFrameRect(bookmark.getFrameRect());
    }

    @Override
    public DrawingAreaStateMemento getMemento() {
        DrawingAreaStateMemento dam = new DrawingAreaStateMemento();
        dam.label = this.getLabelText();
        dam.frameColor = this.getFrameColor();
        dam.id = this.id;
        dam.ideationSpaceId = this.ideationSpaceId;
        dam.transformation = this.transformation;
        return dam;
    }

    @Override
    public String getLabelText() {
        return this.labelText;
    }

    @Override
    public UUID getID() {
        return this.id;
    }

    @Override
    public void applyTransformation(DrawingAreaTransformation datrf) {
        Quaternion r = datrf.getRotation();
        Vector3f p = datrf.getTranslation();
        FrameRect fr = datrf.getFrameRect();
        this.setRotation(r);
        this.setPosition(p);
        this.setFrameRect(fr);
    }

    @Override
    public void registerListener(HisDrawingAreaListener listener) {
        this.listeners.add(listener);
    }

    public void unRegisterListener(HisDrawingAreaListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void adaptTo(DrawingAreaStateMemento dam) {
        this.applyTransformation(dam.transformation);
        this.setDrawingAreaLabelText(dam.label);
        this.setFrameColor(dam.frameColor);
    }

    @Override
    public UUID getIdeationSpaceId() {
        return null;
    }

    @Override
    public void setOwningIdeationSpace(IdeationSpace owner) {
        this.owner = owner;
    }

    @Override
    public void hide() {
        this.visualization.onVisibilityChanged(this, false);
    }

    @Override
    public void show() {
        this.visualization.onVisibilityChanged(this, true);
    }

    public void setIgnoreCamRigUpdates(boolean ignoreCamRigUpdates) {
        this.ignoreCamRigUpdates = ignoreCamRigUpdates;
        if (this.visualization != null) {
            this.visualization.setIgnoreCamRigUpdates(ignoreCamRigUpdates);
        }
        this.transformation.setIgnoreCamRigUpdates(ignoreCamRigUpdates);
    }

    @Override
    public void setKeepAlignmentDuringCameraRotation(boolean b) {
        this.setIgnoreCamRigUpdates(!b);
    }

    public void onTabletDeviceRotationHasChanged(TabletDevice tabletDevice) {
        this.setRotation(this.camrigRotation.mult(tabletDevice.getRotation()));
    }

    public void setStyle(DrawingAreaStyle style) {
        if (!this.style.equals((Object)style)) {
            this.style = style;
            for (HisDrawingAreaListener l : this.listeners) {
                l.onStyleHasChanged(this, style);
            }
        }
    }

    public void setHingeBaseTransformation(DrawingAreaTransformation datrf) {
        this.hingeBaseTransformation = datrf;
        this.logger.info(this.hingeBaseTransformation.toString());
    }

    public static enum DrawingAreaStyle {
        REGULAR,
        ACTIVE_SELECTION_PROCESS,
        MODIFY_SELECTION;

    }

    class DATransformObserver
    implements DrawingAreaTransformation.DrawAreaTransformationValueObserver,
    ClientStateListener {
        private DrawingAreaTransformation observedTransformation;
        private Client myClient;

        public DATransformObserver(DrawingAreaTransformation transformationToObserve) {
            this.observedTransformation = transformationToObserve;
        }

        public void startObserving() {
            this.connect();
            this.observedTransformation.addValueObserver(this);
        }

        private void connect() {
            try {
                this.myClient = Network.connectToServer((String)"localhost", (int)9887);
                this.myClient.start();
                this.myClient.addClientStateListener((ClientStateListener)this);
            }
            catch (ConnectException connectException) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void hasChanged(DrawingAreaTransformation t) {
            if (null != this.myClient && this.myClient.isConnected()) {
                DrawAreaTransformStateMessage m = new DrawAreaTransformStateMessage(t);
                this.myClient.send((Message)m);
            }
        }

        public void clientConnected(Client arg0) {
            System.out.println(String.format("clientConnected( Client %s)", arg0.toString()));
        }

        public void clientDisconnected(Client arg0, ClientStateListener.DisconnectInfo arg1) {
            System.out.println(String.format("clientDisconnected( Client %s, DisconnectInfo %s reason %s)", arg0.toString(), arg1.toString(), arg1.reason));
        }
    }
}

