/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core;

import com.jme3.math.FastMath;
import com.jme3.math.Vector2f;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

@com.jme3.network.serializing.Serializable
public class FrameRect
implements Serializable {
    private static final long serialVersionUID = 7337521059618008928L;
    public Vector2f topleft = new Vector2f(-1.0f, 1.0f);
    public Vector2f bottomright = new Vector2f(1.0f, -1.0f);
    private static final String KEY_TOP = "top";
    private static final String KEY_LEFT = "left";
    private static final String KEY_BOTTOM = "bottom";
    private static final String KEY_RIGHT = "right";

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bottomright == null ? 0 : this.bottomright.hashCode());
        result = 31 * result + (this.topleft == null ? 0 : this.topleft.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FrameRect other = (FrameRect)obj;
        if (this.bottomright == null ? other.bottomright != null : !this.bottomright.equals((Object)other.bottomright)) {
            return false;
        }
        return !(this.topleft == null ? other.topleft != null : !this.topleft.equals((Object)other.topleft));
    }

    public FrameRect() {
    }

    public FrameRect(float aspectRatioWidthDividedByHeight) {
        if (aspectRatioWidthDividedByHeight == 0.0f) {
            throw new IllegalArgumentException("Aspect ratio must not be zero.");
        }
        this.setAspectRatioKeepHeight(aspectRatioWidthDividedByHeight);
    }

    public FrameRect(FrameRect prototype) {
        this.bottomright = prototype.bottomright.clone();
        this.topleft = prototype.topleft.clone();
    }

    private void setAspectRatioKeepHeight(float aspectRatioWidthDividedByHeight) {
        this.topleft.x *= aspectRatioWidthDividedByHeight;
        this.bottomright.x *= aspectRatioWidthDividedByHeight;
    }

    @Deprecated
    public static FrameRect withWidthAndHeight(float width, float height) {
        FrameRect r = new FrameRect();
        r.setWidthAndHeight(width, height);
        return r;
    }

    public String toString() {
        return String.format("topleft: %s bottomright %s", this.topleft.toString(), this.bottomright.toString());
    }

    public JSONObject asJSONObject() throws JSONException {
        JSONObject jfr = new JSONObject();
        jfr.put(KEY_LEFT, (double)this.topleft.x);
        jfr.put(KEY_TOP, (double)this.topleft.y);
        jfr.put(KEY_RIGHT, (double)this.bottomright.x);
        jfr.put(KEY_BOTTOM, (double)this.bottomright.y);
        return jfr;
    }

    public static FrameRect fromJSONObject(JSONObject jfr) throws JSONException {
        FrameRect r = new FrameRect();
        r.topleft.x = (float)jfr.getDouble(KEY_LEFT);
        r.topleft.y = (float)jfr.getDouble(KEY_TOP);
        r.bottomright.x = (float)jfr.getDouble(KEY_RIGHT);
        r.bottomright.y = (float)jfr.getDouble(KEY_BOTTOM);
        return r;
    }

    public void setWidthAndHeight(float w, float h) {
        this.topleft.x = -w * 0.5f;
        this.topleft.y = h * 0.5f;
        this.bottomright.x = w * 0.5f;
        this.bottomright.y = -h * 0.5f;
    }

    public float getDiagonalLength() {
        Vector2f l = new Vector2f(this.topleft.x, this.topleft.y);
        l.addLocal(-1.0f * this.bottomright.x, -1.0f * this.bottomright.y);
        return l.length();
    }

    public float getWidth() {
        return FastMath.abs((float)(this.bottomright.x - this.topleft.x));
    }

    public float getHeight() {
        return FastMath.abs((float)(this.bottomright.y - this.topleft.y));
    }

    public FrameRect mult(float zoomValue) {
        FrameRect fr = new FrameRect();
        Vector2f center = this.topleft.add(this.bottomright.subtract(this.topleft).mult(0.5f));
        Vector2f newBottomRight = center.add(this.bottomright.subtract(center).mult(zoomValue));
        Vector2f newTopLeft = center.add(this.topleft.subtract(center).mult(zoomValue));
        fr.bottomright = newBottomRight;
        fr.topleft = newTopLeft;
        return fr;
    }

    public void multLocal(float zoomValue) {
        Vector2f center = this.topleft.add(this.bottomright.subtract(this.topleft).mult(0.5f));
        Vector2f newBottomRight = center.add(this.bottomright.subtract(center).mult(zoomValue));
        Vector2f newTopLeft = center.add(this.topleft.subtract(center).mult(zoomValue));
        this.bottomright = newBottomRight;
        this.topleft = newTopLeft;
    }

    public FrameRect getCopy() {
        FrameRect copy = new FrameRect();
        copy.bottomright = this.bottomright;
        copy.topleft = this.topleft;
        return copy;
    }
}

