/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core;

import com.hybridlab.hyve3d.core.AbstractStroke;
import com.hybridlab.hyve3d.core.Stroke3DDataObserver;
import com.hybridlab.hyve3d.core.Stroke3DPoint;
import com.hybridlab.hyve3d.core.StrokeId;
import com.hybridlab.hyve3d.core.StrokeInk;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.network.interconnection.HisStroke;
import com.hybridlab.hyve3d.network.interconnection.StrokeMemento;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Line;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jogamp.opengl.math.geom.AABBox;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;

public class Stroke3D
extends AbstractStroke
implements HisStroke {
    private List<Stroke3DDataObserver> dataObserver = new ArrayList<Stroke3DDataObserver>();
    private List<Stroke3DPoint> strokePoints = new ArrayList<Stroke3DPoint>();
    private boolean keepInkInProjection = false;
    private boolean undoAble = true;
    private boolean deleteAble = true;
    private boolean saveAble = true;
    private boolean isRemote = false;
    private Vector3f pivotInSceneSpace = Vector3f.ZERO;
    private Transformation transformation = new Transformation();
    private Quaternion strokeOrientation;
    private AABBox bounds = new AABBox(Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN);
    private boolean selected = false;
    private boolean selectable = true;

    public Stroke3D(float thickness, ColorRGBA color) {
        this(StrokeInk.createWithThicknessAndColor(thickness, color));
    }

    public Stroke3D(Float thickness, ColorRGBA color, StrokeInk.StrokeStyle style) {
        this(StrokeInk.createWithThicknessAndColor(thickness.floatValue(), color, style));
    }

    public Stroke3D(StrokeInk ink) {
        this.setInk(ink);
    }

    public Stroke3D(StrokeMemento strokeMemento) {
        this.id = new StrokeId(strokeMemento.id);
        this.setInk(StrokeInk.createWithThicknessAndColor(1.0f, ColorRGBA.Pink));
        this.setInk(strokeMemento.ink);
        this.strokePoints = strokeMemento.strokePoints;
    }

    public void registerDataObserver(Stroke3DDataObserver o) {
        this.dataObserver.add(o);
    }

    public void removeDataObserver(Stroke3DDataObserver o) {
        this.dataObserver.remove(o);
    }

    @Override
    public void addPoint(Stroke3DPoint p) {
        if (p.orientation.equals((Object)Quaternion.ZERO)) {
            Quaternion q;
            if (this.strokeOrientation != null) {
                p.orientation = this.strokeOrientation;
            } else if (this.strokePoints.size() > 2 && (q = this.calcBestStrokeOrientation()) != null) {
                p.orientation = q;
                this.strokeOrientation = q;
            }
        }
        if (this.strokePoints.isEmpty()) {
            this.bounds = new AABBox(p.position.x, p.position.y, p.position.z, p.position.x, p.position.y, p.position.z);
        } else {
            this.bounds.resize(p.position.x, p.position.y, p.position.z);
        }
        this.strokePoints.add(p);
        if (this.dataObserver != null) {
            for (Stroke3DDataObserver o : this.dataObserver) {
                o.onPointAdded(this, this.strokePoints.size() - 1);
            }
        }
    }

    private void recalculateBounds() {
        boolean first = true;
        for (Stroke3DPoint p : this.getPointsInSceneCoordinates()) {
            if (first) {
                this.bounds = new AABBox(p.position.x, p.position.y, p.position.z, p.position.x, p.position.y, p.position.z);
                first = false;
                continue;
            }
            this.bounds.resize(p.position.x, p.position.y, p.position.z);
        }
    }

    private Quaternion calcBestStrokeOrientation() {
        Stroke3DPoint first = this.strokePoints.get(0);
        Stroke3DPoint last = this.strokePoints.get(this.strokePoints.size() - 1);
        Line l = new Line(first.position, last.position);
        float d = 0.0f;
        int maxdistanceindex = 0;
        for (int i = 1; i < this.strokePoints.size() - 1; ++i) {
            float dist = l.distanceSquared(this.strokePoints.get((int)i).position);
            if (!(dist > d)) continue;
            d = dist;
            maxdistanceindex = i;
        }
        if (maxdistanceindex != 0) {
            Vector3f middle = this.strokePoints.get((int)maxdistanceindex).position;
            Vector3f[] axes = new Vector3f[3];
            axes[0] = last.position.subtract(first.position).normalize();
            axes[2] = axes[0].cross(middle.subtract(first.position)).normalize();
            axes[1] = axes[2].cross(axes[0]).normalize();
            Quaternion q = new Quaternion();
            q = q.fromAxes(axes);
            return q;
        }
        return null;
    }

    public void reCalculateOrientation() {
        Quaternion o = this.calcBestStrokeOrientation();
        if (o != null) {
            this.strokeOrientation = o;
            for (Stroke3DPoint sp : this.strokePoints) {
                sp.orientation = o;
            }
        }
    }

    public void finish() {
        HashSet<Stroke3DDataObserver> observers = new HashSet<Stroke3DDataObserver>(this.dataObserver);
        if (this.dataObserver != null) {
            for (Stroke3DDataObserver o : observers) {
                o.onLastPointWasAdded(this);
            }
        }
    }

    public boolean keepInkInProjection() {
        return this.keepInkInProjection;
    }

    public void setKeepInkInProjection(boolean keepInkInProjection) {
        this.keepInkInProjection = keepInkInProjection;
    }

    public boolean isUndoAble() {
        return this.undoAble;
    }

    public void setUndoAble(boolean undoAble) {
        this.undoAble = undoAble;
    }

    public boolean isEraseAble() {
        return this.deleteAble;
    }

    public void setEraseAble(boolean erasingAllowed) {
        this.deleteAble = erasingAllowed;
    }

    public boolean isSaveAble() {
        return this.saveAble;
    }

    public void setSaveAble(boolean saveable) {
        this.saveAble = saveable;
    }

    @Override
    public UUID getId() {
        return this.getStrokeId().getUUID();
    }

    @Override
    public StrokeMemento getMemento() {
        StrokeMemento m = new StrokeMemento();
        m.id = this.getId();
        ArrayList<Stroke3DPoint> strokePointCopys = new ArrayList<Stroke3DPoint>();
        for (Stroke3DPoint p : this.getPointsInSceneCoordinates()) {
            strokePointCopys.add(p.copy());
        }
        m.strokePoints = strokePointCopys;
        m.ink = this.ink;
        return m;
    }

    public boolean isRemoteStroke() {
        return this.isRemote;
    }

    public void setIsRemote(boolean b) {
        this.isRemote = b;
    }

    @Override
    public void setVisibility(Boolean visibility) {
        this.setStatus(visibility != false ? AbstractStroke.StrokeStatus.VISIBLE : AbstractStroke.StrokeStatus.INVISIBLE);
    }

    @Override
    public int getNumberOfPoints() {
        return this.strokePoints.size();
    }

    public Stroke3DPoint getStrokePoint(int pointIndex) {
        return this.strokePoints.get(pointIndex);
    }

    public List<Stroke3DPoint> getPointsInSceneCoordinates() {
        ArrayList<Stroke3DPoint> returnedPoints = new ArrayList<Stroke3DPoint>();
        for (Stroke3DPoint p : this.strokePoints) {
            Stroke3DPoint c = p.copy();
            c.position = this.transformation.getRotation().mult(c.position.subtract(this.pivotInSceneSpace)).add(this.pivotInSceneSpace);
            c.position.addLocal(this.transformation.getPosition());
            returnedPoints.add(c);
        }
        return returnedPoints;
    }

    public AABBox getAABBox() {
        return this.bounds;
    }

    public void setSelected(boolean b) {
        if (!b == this.selected) {
            this.selected = b;
            for (Stroke3DDataObserver l : this.dataObserver) {
                l.onSelectedStateChanged(this);
            }
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setIsSelectable(boolean isSelectable) {
        this.selectable = isSelectable;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public Stroke3D createCopyWithRandomID() {
        StrokeMemento m = this.getMemento();
        m.id = UUID.randomUUID();
        Stroke3D copy = new Stroke3D(m);
        copy.recalculateBounds();
        return copy;
    }

    public Vector3f getPosition() {
        return this.transformation.getPosition();
    }

    @Override
    public void setPosition(Vector3f pos) {
        if (!pos.equals((Object)this.transformation.getPosition())) {
            Transformation t;
            Vector3f olpos = this.transformation.getPosition().clone();
            this.transformation = t = new Transformation(pos, this.transformation.getRotation());
            this.adaptPivot(olpos, this.transformation.getPosition());
            for (Stroke3DDataObserver l : this.dataObserver) {
                l.onPositionChanged(this);
            }
        }
    }

    private void adaptPivot(Vector3f oldPos, Vector3f newPos) {
        Vector3f pivotdiff = newPos.subtract(oldPos);
        this.setPivotInSceneSpace(this.pivotInSceneSpace.add(pivotdiff));
    }

    public Quaternion getRotation() {
        return this.transformation.getRotation();
    }

    public void setPivotInSceneSpace(Vector3f pivot) {
        if (!this.pivotInSceneSpace.equals((Object)pivot)) {
            System.out.println(String.format("Stroke3D.setPivotInSceneSpace old=%s new=%s", this.pivotInSceneSpace, pivot));
            this.pivotInSceneSpace = pivot;
            this.recalculateBounds();
            for (Stroke3DDataObserver l : this.dataObserver) {
                l.onPivotChanged(this);
            }
        }
    }

    @Override
    public void setRotation(Quaternion q) {
        if (!this.transformation.getRotation().equals((Object)q)) {
            Transformation t;
            this.transformation = t = new Transformation(this.transformation.getPosition(), q);
            this.recalculateBounds();
            for (Stroke3DDataObserver l : this.dataObserver) {
                l.onRotationChanged(this);
            }
        }
    }

    public Vector3f getPivotInStrokeSpace() {
        return this.pivotInSceneSpace.subtract(this.getPosition());
    }
}

