/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core;

import com.hybridlab.hyve3d.core.StylusPressure;
import com.hybridlab.utils.math.MathUtils;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.network.serializing.Serializable;

@Serializable
public class Stroke3DPoint {
    public static final Stroke3DPoint ZERO = Stroke3DPoint.create(Vector3f.ZERO, StylusPressure.NoPressure, 0, Quaternion.DIRECTION_Z);
    public Integer indexInStroke = -1;
    public Vector3f position = Vector3f.ZERO;
    public StylusPressure pressure = StylusPressure.NoPressure;
    public Quaternion orientation = Quaternion.ZERO;

    public String toString() {
        return "Stroke3DPoint [position=" + this.position + ", pressure=" + this.pressure + ", indexInStroke=" + this.indexInStroke + ", orientation=" + MathUtils.quaternionToAxisAngleInDegreesString(this.orientation) + ", hashCode()=" + this.hashCode() + "]";
    }

    public static Stroke3DPoint create(Vector3f p, float normalizedPressure) {
        Stroke3DPoint sp = new Stroke3DPoint();
        sp.position = p;
        sp.pressure = new StylusPressure(normalizedPressure);
        return sp;
    }

    public static Stroke3DPoint create(Vector3f pnt, StylusPressure pressure) {
        Stroke3DPoint sp = new Stroke3DPoint();
        sp.position = pnt;
        sp.pressure = pressure;
        return sp;
    }

    public static Stroke3DPoint create(Vector3f pnt, StylusPressure pressure, int index, Quaternion orientation) {
        Stroke3DPoint sp = new Stroke3DPoint();
        sp.indexInStroke = index;
        sp.position = pnt;
        sp.pressure = pressure;
        sp.orientation = orientation;
        return sp;
    }

    public static Stroke3DPoint create(Vector3f pnt, StylusPressure pressure, Quaternion orientation) {
        Stroke3DPoint sp = new Stroke3DPoint();
        sp.position = pnt;
        sp.pressure = pressure;
        sp.orientation = orientation;
        return sp;
    }

    public Stroke3DPoint copy() {
        return Stroke3DPoint.create(this.position.clone(), this.pressure, this.indexInStroke, this.orientation);
    }
}

