/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core;

import com.jme3.math.ColorRGBA;
import com.jme3.network.serializing.Serializable;

@Serializable
public class StrokeInk {
    private ColorRGBA color = ColorRGBA.Yellow;
    private float thickness = 2.0f;
    private float pressureFactor = 3.0f;
    private StrokeStyle style = StrokeStyle.TriangleStrokeTube;

    public static StrokeInk createCopyOf(StrokeInk original) {
        StrokeInk copy = new StrokeInk();
        copy.thickness = original.getThickness();
        copy.color = original.getColor().clone();
        copy.style = original.getStyle();
        copy.pressureFactor = original.getPressureFactor();
        return copy;
    }

    public StrokeStyle getStyle() {
        return this.style;
    }

    public StrokeInk clone() {
        return StrokeInk.createCopyOf(this);
    }

    public float getThickness() {
        return this.thickness;
    }

    public void setThickness(float thickness) {
        this.thickness = thickness;
    }

    public ColorRGBA getColor() {
        return this.color;
    }

    public void setColor(ColorRGBA color) {
        this.color = color;
    }

    public static StrokeInk createDefaultProjectionInk() {
        StrokeInk i = new StrokeInk();
        i.color = ColorRGBA.LightGray.clone();
        i.color.a = 0.6f;
        i.thickness = 5.0f;
        return i;
    }

    public static StrokeInk createWithThicknessAndColor(float thickness, ColorRGBA color, StrokeStyle style) {
        StrokeInk i = new StrokeInk();
        i.color = color.clone();
        i.thickness = thickness;
        i.style = style;
        return i;
    }

    public static StrokeInk createWithThicknessAndColor(float thickness, ColorRGBA color) {
        StrokeInk i = new StrokeInk();
        i.color = color.clone();
        i.thickness = thickness;
        i.style = StrokeStyle.TriangleStrokeTube;
        return i;
    }

    public void setStyle(StrokeStyle style) {
        this.style = style;
    }

    public float getPressureFactor() {
        return this.pressureFactor;
    }

    public void setPressureFactor(float pressureFactor) {
        this.pressureFactor = pressureFactor;
    }

    public static enum StrokeStyle {
        TriangleStrokeTube,
        Line,
        RectangleStrokeTube;

    }
}

