/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core;

import com.hybridlab.hyve3d.core.StrokeInputCommand;
import java.util.ArrayList;
import java.util.List;

public class StrokeInputBuffer {
    List<StrokeInputCommand> strokeInputBuffer = new ArrayList<StrokeInputCommand>();
    private boolean isLocked = false;

    public boolean isLocked() {
        return this.isLocked;
    }

    public boolean hasInput() {
        try {
            this.lock();
            boolean bl = !this.strokeInputBuffer.isEmpty();
            return bl;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.unlock();
        }
        return false;
    }

    public void add(StrokeInputCommand cmd) {
        try {
            this.lock();
            this.strokeInputBuffer.add(cmd);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.unlock();
        }
    }

    public List<StrokeInputCommand> getBufferContentAndClear() {
        try {
            this.lock();
            ArrayList<StrokeInputCommand> copy = new ArrayList<StrokeInputCommand>(this.strokeInputBuffer);
            this.strokeInputBuffer.clear();
            ArrayList<StrokeInputCommand> arrayList = copy;
            return arrayList;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.unlock();
        }
        return new ArrayList<StrokeInputCommand>();
    }

    public synchronized void lock() throws InterruptedException {
        while (this.isLocked) {
            this.wait();
        }
        this.isLocked = true;
    }

    public synchronized void unlock() {
        this.isLocked = false;
        this.notify();
    }
}

