/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core;

public class TransformationOptions {
    private static int bit_rx = 0;
    private static int bit_ry = 1;
    private static int bit_rz = 2;
    private static int bit_tx = 3;
    private static int bit_ty = 4;
    private static int bit_tz = 5;
    private static int bit_tgx = 6;
    private static int bit_tgy = 7;
    private static int bit_tgz = 8;
    private static int bit_hingetop = 9;
    private static int bit_hingebottom = 10;
    private static int bit_hingeleft = 11;
    private static int bit_hingeright = 12;
    private static int bit_hingecenter = 13;
    private static int bit_hinge_autodetect = 14;
    public TransformationFilter transformFilter = TransformationFilter.RXYZ_TGXYZ;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.transformFilter == null ? 0 : this.transformFilter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransformationOptions other = (TransformationOptions)obj;
        return this.transformFilter == other.transformFilter;
    }

    public String toString() {
        return String.valueOf((Object)this.transformFilter);
    }

    public static enum TransformationFilter {
        NOTHING(0),
        RX(1 << bit_rx),
        RY(1 << bit_ry),
        RZ(1 << bit_rz),
        TX(1 << bit_tx),
        TY(1 << bit_ty),
        TZ(1 << bit_tz),
        HINGE_TOP(1 << bit_hingetop),
        HINGE_BOTTOM(1 << bit_hingebottom),
        HINGE_LEFT(1 << bit_hingeleft),
        HINGE_RIGHT(1 << bit_hingeright),
        HINGE_CENTER(1 << bit_hingecenter),
        HINGE_AUTODETECT(1 << bit_hinge_autodetect),
        RXYZ_TGXYZ(1 << bit_rx | 1 << bit_ry | 1 << bit_rz | 1 << bit_tx | 1 << bit_ty | 1 << bit_tz | 1 << bit_tgx | 1 << bit_tgy | 1 << bit_tgz),
        TXY(1 << bit_tx | 1 << bit_ty),
        TGXYZ(1 << bit_tx | 1 << bit_ty | 1 << bit_tz | 1 << bit_tgx | 1 << bit_tgy | 1 << bit_tgz),
        TGXZ(1 << bit_tgx | 1 << bit_tgz);

        private final int mask;

        private TransformationFilter(int mask) {
            this.mask = mask;
        }

        public int mask() {
            return this.mask;
        }

        public static TransformationFilter getFromMask(int rotation) {
            for (TransformationFilter o : TransformationFilter.values()) {
                if (o.mask != rotation) continue;
                return o;
            }
            return NOTHING;
        }
    }
}

