/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.animation;

import com.hybridlab.hyve3d.core.Transformable;
import com.hybridlab.hyve3d.core.animation.InfiniteTransformableAnimation;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.utils.Interpolation;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;

public class CircularTransformableAnimation
extends InfiniteTransformableAnimation {
    public Quaternion currentAnimativeRotation = new Quaternion();
    private float actualAngle = 0.0f;
    private float sumWalkedAngle = 0.0f;
    private Vector3f planeNormal = Vector3f.UNIT_Y;
    private Vector3f center = Vector3f.ZERO;
    float circlePartSizeInDegrees = 45.0f;
    float angleSpeedPerSecond = this.circlePartSizeInDegrees * 0.5f;

    public CircularTransformableAnimation(Transformable animative) {
        super(animative);
    }

    @Override
    protected Transformation calculateTargetTrf(float tpf) {
        Vector3f targetTranslation = this.calculateTargetPosition(tpf);
        Quaternion q = new Quaternion();
        q.fromAngleAxis((float)Math.PI / 180 * this.actualAngle, this.planeNormal);
        Quaternion currentAnimativeRotation = q.mult(this.initialTransformation.getRotation());
        Transformation tnew = new Transformation(targetTranslation, currentAnimativeRotation);
        return tnew;
    }

    public void setCirclePlaneNormal(Vector3f planeNormal) {
        this.planeNormal = planeNormal;
    }

    private Vector3f calculateTargetPosition(float tpf) {
        float stepAngle = this.calculateStepAngle(tpf);
        this.sumWalkedAngle += stepAngle;
        this.actualAngle = this.calcActualAngle();
        Quaternion r = new Quaternion();
        r.fromAngleAxis((float)Math.PI / 180 * this.actualAngle, this.planeNormal);
        Vector3f centerToPosition = this.initialTransformation.getPosition().subtract(this.center);
        Vector3f rotatedCenterToPosition = r.mult(centerToPosition);
        Vector3f target = this.center.add(rotatedCenterToPosition);
        return target;
    }

    @Override
    void reset() {
        super.reset();
        this.sumWalkedAngle = 0.0f;
    }

    private float calcActualAngle() {
        float fraction = this.sumWalkedAngle / this.circlePartSizeInDegrees;
        float cyclePart = FastMath.floor((float)fraction);
        float fractionPart = this.sumWalkedAngle - this.circlePartSizeInDegrees * cyclePart;
        float normalizedFractionPart = Interpolation.inttrf(fractionPart, 0.0f, this.circlePartSizeInDegrees, 0.0f, 1.0f);
        float phasePart = FastMath.floor((float)(normalizedFractionPart * 4.0f));
        int phase = (int)phasePart;
        if (phase % 4 == 0) {
            this.actualAngle = Interpolation.inttrf(normalizedFractionPart, 0.0f, 0.25f, 0.0f, 0.5f * this.circlePartSizeInDegrees);
        } else if (phase % 4 == 1) {
            this.actualAngle = Interpolation.inttrf(normalizedFractionPart, 0.25f, 0.5f, 0.5f * this.circlePartSizeInDegrees, 0.0f);
        } else if (phase % 4 == 2) {
            this.actualAngle = Interpolation.inttrf(normalizedFractionPart, 0.5f, 0.75f, 0.0f, -0.5f * this.circlePartSizeInDegrees);
        } else if (phase % 4 == 3) {
            this.actualAngle = Interpolation.inttrf(normalizedFractionPart, 0.75f, 1.0f, -0.5f * this.circlePartSizeInDegrees, 0.0f);
        }
        return this.actualAngle;
    }

    private float calculateStepAngle(float tpf) {
        float introductionFactor = 1.0f;
        if (this.currentAnimationTime < this.introductionDurationInSeconds) {
            introductionFactor = Interpolation.inttrf(this.currentAnimationTime, 0.0f, this.introductionDurationInSeconds, 0.0f, 1.0f);
            introductionFactor = Interpolation.slowInFastOut_smoothTrigonometrical(introductionFactor, 2);
        }
        float step = this.angleSpeedPerSecond * tpf * introductionFactor;
        return step;
    }

    public void setCenter(Vector3f center) {
        this.center = center;
    }

    public void setCirclePartSizeInDegrees(float degrees) {
        this.circlePartSizeInDegrees = degrees;
    }

    public void setDegreesPerSecond(float angleSpeed) {
        this.angleSpeedPerSecond = angleSpeed;
    }
}

