/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.animation;

import com.hybridlab.hyve3d.core.animation.InfiniteTranslationAnimation;
import com.hybridlab.hyve3d.core.animation.PositionAndRotationChangeAble;
import com.hybridlab.utils.Interpolation;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;

public class CircularTranslationAnimation
extends InfiniteTranslationAnimation {
    public Quaternion currentAnimativeRotation = new Quaternion();
    private float actualAngle = 0.0f;
    private float sumWalkedAngle = 0.0f;
    boolean smooth = false;
    Vector3f center = Vector3f.ZERO;
    Vector3f initialPosition = Vector3f.UNIT_X;
    Vector3f planeNormal = Vector3f.UNIT_Y;
    float circlePartSizeInDegrees = 45.0f;
    float angleSpeedPerSecond = this.circlePartSizeInDegrees * 0.5f;
    Quaternion initialRotation;

    public CircularTranslationAnimation(PositionAndRotationChangeAble animative) {
        super(animative);
    }

    @Override
    Vector3f calculateTargetPosition(float tpf) {
        float stepAngle = this.calculateStepAngle(tpf);
        this.sumWalkedAngle += stepAngle;
        float actualAngle = this.calcActualAngle();
        Quaternion r = new Quaternion();
        r.fromAngleAxis((float)Math.PI / 180 * actualAngle, this.planeNormal);
        Vector3f centerToPosition = this.initialPosition.subtract(this.center);
        Vector3f rotatedCenterToPosition = r.mult(centerToPosition);
        Vector3f target = this.center.add(rotatedCenterToPosition);
        return target;
    }

    @Override
    void reset() {
        super.reset();
        this.sumWalkedAngle = 0.0f;
    }

    private float calcActualAngle() {
        float fraction = this.sumWalkedAngle / this.circlePartSizeInDegrees;
        float cyclePart = FastMath.floor((float)fraction);
        float fractionPart = this.sumWalkedAngle - this.circlePartSizeInDegrees * cyclePart;
        if (this.smooth) {
            this.actualAngle = FastMath.sin((float)Interpolation.inttrf(fractionPart, 0.0f, this.circlePartSizeInDegrees, 0.0f, (float)Math.PI * 2)) * 0.5f * this.circlePartSizeInDegrees;
            return this.actualAngle;
        }
        float normalizedFractionPart = Interpolation.inttrf(fractionPart, 0.0f, this.circlePartSizeInDegrees, 0.0f, 1.0f);
        float phasePart = FastMath.floor((float)(normalizedFractionPart * 4.0f));
        int phase = (int)phasePart;
        if (phase % 4 == 0) {
            this.actualAngle = Interpolation.inttrf(normalizedFractionPart, 0.0f, 0.25f, 0.0f, 0.5f * this.circlePartSizeInDegrees);
        } else if (phase % 4 == 1) {
            this.actualAngle = Interpolation.inttrf(normalizedFractionPart, 0.25f, 0.5f, 0.5f * this.circlePartSizeInDegrees, 0.0f);
        } else if (phase % 4 == 2) {
            this.actualAngle = Interpolation.inttrf(normalizedFractionPart, 0.5f, 0.75f, 0.0f, -0.5f * this.circlePartSizeInDegrees);
        } else if (phase % 4 == 3) {
            this.actualAngle = Interpolation.inttrf(normalizedFractionPart, 0.75f, 1.0f, -0.5f * this.circlePartSizeInDegrees, 0.0f);
        }
        return this.actualAngle;
    }

    private float calculateStepAngle(float tpf) {
        float introductionFactor = 1.0f;
        if (this.currentAnimationTime < this.introductionDurationInSeconds) {
            introductionFactor = Interpolation.inttrf(this.currentAnimationTime, 0.0f, this.introductionDurationInSeconds, 0.0f, 1.0f);
            introductionFactor = Interpolation.slowInFastOut_smoothTrigonometrical(introductionFactor, 2);
        }
        float step = this.angleSpeedPerSecond * tpf * introductionFactor;
        return step;
    }

    public void setCenter(Vector3f center) {
        this.center = center;
    }

    public void setInitialPosition(Vector3f initialPosition) {
        this.initialPosition = initialPosition;
    }

    public void setCirclePlaneNormal(Vector3f planeNormal) {
    }

    public void setCirclePartSizeInDegrees(float degrees) {
        this.circlePartSizeInDegrees = degrees;
    }

    public void setDegreesPerSecond(float angleSpeed) {
        this.angleSpeedPerSecond = angleSpeed;
    }

    @Override
    public void start() {
        super.start();
        this.initialRotation = this.animative.getRotation();
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    public void update(float tpf) {
        super.update(tpf);
        if (this.isRunning() && !this.isFinished()) {
            Quaternion q = new Quaternion();
            q.fromAngleAxis((float)Math.PI / 180 * this.actualAngle, this.planeNormal);
            this.currentAnimativeRotation = q.mult(this.initialRotation);
            this.animative.setRotation(this.currentAnimativeRotation);
        }
    }

    @Override
    public Quaternion getStartRotation() {
        return this.initialRotation.clone();
    }

    @Override
    public Quaternion getCurrentRotation() {
        return this.currentAnimativeRotation.clone();
    }
}

