/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.animation;

import com.hybridlab.hyve3d.core.Transformable;
import com.hybridlab.hyve3d.core.animation.SimpleAnimation;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.utils.Interpolation;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;

public class InfiniteTransformableAnimation
implements SimpleAnimation {
    protected Transformable animative;
    protected Transformation initialTransformation;
    private Vector3f translationPerSecond = Vector3f.ZERO;
    float currentAnimationTime = 0.0f;
    float duration = 1.0f;
    float introductionDurationInSeconds = 0.0f;
    private boolean started = false;
    private boolean finished = false;
    private boolean running = false;

    public InfiniteTransformableAnimation(Transformable animative) {
        this.animative = animative;
        this.initialTransformation = this.animative.getTransformation().copy();
    }

    @Override
    public void update(float tpf) {
        if (this.running && !this.finished) {
            this.currentAnimationTime += tpf;
            Transformation t = this.calculateTargetTrf(tpf);
            this.animative.setTransformation(t);
        }
    }

    protected Transformation calculateTargetTrf(float tpf) {
        Transformation currentTranslation = this.animative.getTransformation();
        Transformation step = this.calculateStep(tpf);
        Vector3f targetTranslation = currentTranslation.getPosition().add(step.getPosition());
        Quaternion targetRotation = step.getRotation().mult(currentTranslation.getRotation());
        Transformation tnew = new Transformation(targetTranslation, targetRotation);
        return tnew;
    }

    public void resume() {
        if (!this.started) {
            this.start();
        }
        this.running = true;
    }

    @Override
    public void start() {
        this.reset();
        this.started = true;
        this.running = true;
    }

    void reset() {
        this.currentAnimationTime = 0.0f;
        this.started = false;
        this.finished = false;
    }

    private Transformation calculateStep(float tpf) {
        float introductionFactor = 1.0f;
        if (this.currentAnimationTime < this.introductionDurationInSeconds) {
            introductionFactor = Interpolation.inttrf(this.currentAnimationTime, 0.0f, this.introductionDurationInSeconds, 0.0f, 1.0f);
            introductionFactor = Interpolation.slowInFastOut_smoothTrigonometrical(introductionFactor, 2);
        }
        Vector3f step = this.translationPerSecond.mult(tpf).mult(introductionFactor);
        Transformation t = new Transformation(step, Quaternion.IDENTITY);
        return t;
    }

    public void setTranslationPerSecond(Vector3f translation) {
        this.translationPerSecond = translation;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void stop() {
        this.running = false;
    }

    public void setIntroDurationInSeconds(float duration) {
        this.introductionDurationInSeconds = duration;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }
}

