/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.commands;

import com.hybridlab.hyve3d.core.commands.Command;
import com.hybridlab.hyve3d.core.commands.CommandChangeMode;
import com.hybridlab.hyve3d.core.commands.CommandChangeModeRequest;
import com.hybridlab.hyve3d.core.commands.CommandDisconnect;
import com.hybridlab.hyve3d.core.commands.CommandMoveDrawingAreaOfSatelliteToBookmark;
import com.hybridlab.hyve3d.core.commands.CommandSetBackgroundImage;
import com.hybridlab.hyve3d.core.commands.CommandSetFrameColor;
import com.hybridlab.hyve3d.core.commands.DrawAreaTransformOptionsCommand;
import com.hybridlab.hyve3d.core.commands.SetSatelliteSelectionModeCommand;
import com.hybridlab.hyve3d.core.commands.SimpleStringCommand;
import com.hybridlab.hyve3d.core.commands.StrokeModificationCommand;
import com.hybridlab.hyve3d.core.commands.UndoRedoCommand;
import com.hybridlab.utils.JsonHelper;
import java.util.Map;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class CommandFactory {
    private static final Logger logger = Logger.getLogger(CommandFactory.class.getSimpleName());

    public static Command create(JSONObject cmdJsonObject) {
        Map<String, Object> params;
        String cmdString = "";
        try {
            cmdString = cmdJsonObject.getString("cmd");
        }
        catch (JSONException e) {
            return null;
        }
        CommandNames commandName = CommandNames.valueOf(cmdString);
        try {
            params = JsonHelper.getMap(cmdJsonObject, "params");
        }
        catch (JSONException e) {
            logger.severe("Parameter for Command " + cmdString);
            return null;
        }
        Command cmd = null;
        switch (commandName) {
            case changeMode: {
                cmd = new CommandChangeMode(params);
                break;
            }
            case changeModeRequest: {
                cmd = new CommandChangeModeRequest(params);
                break;
            }
            case drawAreaTransformOptions: {
                cmd = new DrawAreaTransformOptionsCommand(params);
                break;
            }
            case disconnect: {
                cmd = new CommandDisconnect(params);
                break;
            }
            case undoredo: {
                cmd = new UndoRedoCommand(params);
                break;
            }
            case strokeModification: {
                cmd = new StrokeModificationCommand(params);
                break;
            }
            case simpleString: {
                cmd = new SimpleStringCommand(params);
                break;
            }
            case moveDrawingAreaToBookMark: {
                cmd = new CommandMoveDrawingAreaOfSatelliteToBookmark(params);
                break;
            }
            case setBackgroundImage: {
                cmd = new CommandSetBackgroundImage(params);
                break;
            }
            case setSatelliteSelectionMode: {
                cmd = new SetSatelliteSelectionModeCommand(params);
                break;
            }
            case setFrameColor: {
                cmd = new CommandSetFrameColor(params);
                break;
            }
            default: {
                logger.severe("can't create Command. Unkown Name: " + cmdString);
                return null;
            }
        }
        return cmd;
    }

    public static enum CommandNames {
        changeModeRequest,
        changeMode,
        hydraState,
        clearDrawingArea,
        drawAreaTransformOptions,
        disconnect,
        undoredo,
        undoredosteps,
        strokeModification,
        simpleString,
        moveDrawingAreaToBookMark,
        setStrokeStyle,
        session,
        joinSessionOnHost,
        setBackgroundImage,
        pairSatelliteWithHydraController,
        setSatelliteSelectionMode,
        setFrameColor,
        setSatelliteName;

    }
}

