/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.jme3;

import com.hybridlab.hyve3d.core.AbstractStroke;
import com.hybridlab.hyve3d.core.His3DCanvas;
import com.hybridlab.hyve3d.core.Stroke3D;
import com.hybridlab.hyve3d.core.Stroke3DDataObserver;
import com.hybridlab.hyve3d.core.Stroke3DJmeVisualization;
import com.hybridlab.hyve3d.core.Stroke3DObserver;
import com.hybridlab.hyve3d.core.Stroke3DPoint;
import com.hybridlab.hyve3d.core.StrokeInk;
import com.hybridlab.hyve3d.core.StrokeStatusObserver;
import com.hybridlab.hyve3d.core.jme3.Jme3HisClientRenderer;
import com.hybridlab.hyve3d.core.jme3.Jme3SceneObject;
import com.jme3.asset.AssetManager;
import com.jme3.scene.Node;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Logger;

public class Jme3Canvas3D
extends Jme3SceneObject
implements His3DCanvas,
Stroke3DDataObserver,
StrokeStatusObserver {
    Set<Stroke3D> visibleStrokes = new HashSet<Stroke3D>();
    Map<Stroke3D, Stroke3DJmeVisualization> strokeVisualizations = new HashMap<Stroke3D, Stroke3DJmeVisualization>();
    Node strokeGroup;
    Stack<Stroke3D> undoStack = new Stack();
    Stack<Stroke3D> redoStack = new Stack();
    Set<Stroke3DObserver> observers = new HashSet<Stroke3DObserver>();
    long creationTimeMillis = 0L;
    private Map<UUID, Stroke3D> strokes = new HashMap<UUID, Stroke3D>();
    private StrokeInk.StrokeStyle defaultStrokeStyle = StrokeInk.StrokeStyle.Line;

    public Jme3Canvas3D(AssetManager assetManager, Jme3HisClientRenderer jmeApp, Thread renderThread) {
        super(assetManager, jmeApp, renderThread);
        this.creationTimeMillis = System.currentTimeMillis();
    }

    @Override
    public long getCreationTimeMilliseconds() {
        return this.creationTimeMillis;
    }

    @Override
    public void setCreationTimeMilliseconds(long creationTimeMillis) {
        this.creationTimeMillis = creationTimeMillis;
    }

    @Override
    public void addStrokeAndPaintCompletely(final Stroke3D s3d) {
        s3d.getInk().setStyle(this.defaultStrokeStyle);
        for (Stroke3DObserver o : this.observers) {
            o.onStrokeWasAddedToCanvas(this, s3d);
        }
        if (!s3d.isRemoteStroke()) {
            s3d.registerDataObserver(this);
            s3d.registerStatusObserver(this);
        }
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() {
                Stroke3DJmeVisualization vis = new Stroke3DJmeVisualization(Jme3Canvas3D.this.assetManager, s3d, Jme3Canvas3D.this.jmeRenderer);
                Jme3Canvas3D.this.strokeVisualizations.put(s3d, vis);
                Jme3Canvas3D.this.strokes.put(s3d.getId(), s3d);
                long addTimeMillis = System.currentTimeMillis();
                s3d.setCreationMilliseconds(addTimeMillis - Jme3Canvas3D.this.creationTimeMillis);
                Jme3Canvas3D.this.showStroke(s3d);
                vis.onSelectedStateChanged(s3d);
                return null;
            }
        };
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeRenderer.enqueue(c);
        } else {
            try {
                c.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void addStroke(final Stroke3D s3d) {
        if (s3d.isUndoAble()) {
            this.undoStack.push(s3d);
            this.eraseRedoStackStrokesAndClearRedoStack();
        }
        s3d.getInk().setStyle(this.defaultStrokeStyle);
        for (Stroke3DObserver o : this.observers) {
            o.onStrokeWasAddedToCanvas(this, s3d);
        }
        if (!s3d.isRemoteStroke()) {
            s3d.registerDataObserver(this);
            s3d.registerStatusObserver(this);
        }
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() {
                Stroke3DJmeVisualization vis = new Stroke3DJmeVisualization(Jme3Canvas3D.this.assetManager, s3d, Jme3Canvas3D.this.jmeRenderer);
                Jme3Canvas3D.this.strokeVisualizations.put(s3d, vis);
                Jme3Canvas3D.this.strokes.put(s3d.getId(), s3d);
                long addTimeMillis = System.currentTimeMillis();
                s3d.setCreationMilliseconds(addTimeMillis - Jme3Canvas3D.this.creationTimeMillis);
                Jme3Canvas3D.this.showStroke(s3d);
                return null;
            }
        };
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeRenderer.enqueue(c);
        } else {
            try {
                c.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void eraseRedoStackStrokesAndClearRedoStack() {
        while (!this.redoStack.isEmpty()) {
            Stroke3D s3d = this.redoStack.pop();
            this.eraseStroke(s3d);
        }
        this.redoStack.clear();
    }

    private void showStroke(final Stroke3D s3d) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() {
                    Jme3Canvas3D.this.showStroke(s3d);
                    return this;
                }
            });
            return;
        }
        Stroke3DJmeVisualization vis = this.strokeVisualizations.get(s3d);
        if (null != vis) {
            this.visibleStrokes.add(s3d);
            this.getRootNode().attachChild(vis.getStrokeRootNode());
        }
        s3d.setStatus(AbstractStroke.StrokeStatus.VISIBLE);
    }

    private void hideStroke(final Stroke3D s3d) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() {
                    Jme3Canvas3D.this.hideStroke(s3d);
                    return this;
                }
            });
            return;
        }
        Stroke3DJmeVisualization vis = this.strokeVisualizations.get(s3d);
        this.visibleStrokes.remove(s3d);
        if (null != vis) {
            this.getRootNode().detachChild(vis.getStrokeRootNode());
        }
        s3d.setStatus(AbstractStroke.StrokeStatus.INVISIBLE);
    }

    @Override
    public void eraseStroke(final Stroke3D s3d) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() {
                    Jme3Canvas3D.this.eraseStroke(s3d);
                    return this;
                }
            });
            return;
        }
        this.hideStroke(s3d);
        this.strokeVisualizations.remove(s3d);
        s3d.setStatus(AbstractStroke.StrokeStatus.ERASED);
    }

    @Override
    public void setVisibilityForStrokeWithoutNotifying(final Stroke3D s3d, final boolean isVisible) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() {
                    Jme3Canvas3D.this.setVisibilityForStrokeWithoutNotifying(s3d, isVisible);
                    return this;
                }
            });
            return;
        }
        if (s3d == null) {
            Logger.getAnonymousLogger().severe("Parameter s3d:Stroke3D is null !");
            return;
        }
        if (isVisible) {
            Stroke3DJmeVisualization vis = this.strokeVisualizations.get(s3d);
            if (null != vis) {
                this.visibleStrokes.add(s3d);
                this.getRootNode().attachChild(vis.getStrokeRootNode());
            }
            s3d.setStatusWithoutNotifying(AbstractStroke.StrokeStatus.VISIBLE);
        } else {
            Stroke3DJmeVisualization vis = this.strokeVisualizations.get(s3d);
            this.visibleStrokes.remove(s3d);
            if (null != vis) {
                this.getRootNode().detachChild(vis.getStrokeRootNode());
            }
            s3d.setStatusWithoutNotifying(AbstractStroke.StrokeStatus.INVISIBLE);
        }
    }

    @Override
    public Set<Stroke3D> getAllVisibleStrokes() {
        return this.visibleStrokes;
    }

    @Override
    public void clear() {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() {
                    Jme3Canvas3D.this.clear();
                    return this;
                }
            });
            return;
        }
        HashSet<Stroke3D> strokesCopy = new HashSet<Stroke3D>(this.strokeVisualizations.keySet());
        for (Stroke3D s : strokesCopy) {
            if (!s.isEraseAble()) continue;
            this.eraseStroke(s);
        }
        this.clearUndoRedoStacks();
    }

    @Override
    public boolean undo() {
        if (this.undoStack.isEmpty()) {
            return false;
        }
        Stroke3D undoStroke = this.undoStack.pop();
        this.redoStack.push(undoStroke);
        this.hideStroke(undoStroke);
        return true;
    }

    @Override
    public boolean redo() {
        if (this.redoStack.isEmpty()) {
            return false;
        }
        Stroke3D redoStroke = this.redoStack.pop();
        this.undoStack.push(redoStroke);
        this.showStroke(redoStroke);
        return true;
    }

    private void clearUndoRedoStacks() {
        this.undoStack.clear();
        this.redoStack.clear();
    }

    @Override
    public Set<Stroke3D> getAllSaveableStrokes() {
        HashSet<Stroke3D> saveables = new HashSet<Stroke3D>();
        for (Stroke3D s : this.strokeVisualizations.keySet()) {
            if (!s.isSaveAble() || !this.visibleStrokes.contains(s)) continue;
            saveables.add(s);
        }
        return saveables;
    }

    @Override
    public void setStyleOfAllStrokes(final StrokeInk.StrokeStyle style) {
        if (!Thread.currentThread().equals(this.renderThread)) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() {
                    Jme3Canvas3D.this.setStyleOfAllStrokes(style);
                    return this;
                }
            });
            return;
        }
        for (Stroke3DJmeVisualization vis : this.strokeVisualizations.values()) {
            vis.setStyle(style);
        }
        this.defaultStrokeStyle = style;
    }

    @Override
    public void addStrokeObserver(Stroke3DObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeStrokeObserver(Stroke3DObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void onLastPointWasAdded(Stroke3D stroke) {
        for (Stroke3DObserver o : this.observers) {
            o.onStrokeWasFinished(stroke.getId());
        }
    }

    @Override
    public void onObservedStrokeErased(AbstractStroke erasedStroke) {
        for (Stroke3DObserver o : this.observers) {
            o.onStrokeWasErased(erasedStroke.getStrokeId().getUUID());
        }
    }

    @Override
    public void onVisibilityOfObservedStrokeChanged(AbstractStroke stroke, boolean isVisible) {
        for (Stroke3DObserver o : this.observers) {
            o.onStrokeVisibilityChanged(stroke.getStrokeId().getUUID(), isVisible);
        }
    }

    @Override
    public Stroke3D getStroke(UUID id) {
        return this.strokes.get(id);
    }

    @Override
    public void onPointAdded(Stroke3D stroke, int pointIndex) {
        Stroke3DPoint p = stroke.getStrokePoint(pointIndex);
        for (Stroke3DObserver o : this.observers) {
            o.onStrokePointWasAdded(stroke.getId(), p);
        }
    }

    @Override
    public void onSelectedStateChanged(Stroke3D stroke) {
    }

    @Override
    public void onPositionChanged(Stroke3D stroke) {
        for (Stroke3DObserver o : this.observers) {
            o.onStrokeWasMoved(stroke.getId(), stroke.getPosition());
        }
    }

    @Override
    public void onRotationChanged(Stroke3D stroke) {
    }

    @Override
    public void onPivotChanged(Stroke3D stroke3d) {
    }
}

