/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.jme3;

import com.hybridlab.hyve3d.core.jme3.Jme3HisClientRenderer;
import com.hybridlab.hyve3d.core.jme3.Jme3SceneObject;
import com.hybridlab.hyve3d.geometry.Line;
import com.hybridlab.hyve3d.scenemanipulation.BrailedVolume;
import com.hybridlab.hyve3d.scenemanipulation.ConvexBiRectangleVolume;
import com.hybridlab.hyve3d.scenemanipulation.Volume;
import com.hybridlab.utils.math.Rectangle3D;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class Jme3VolumeVisualization
extends Jme3SceneObject
implements BrailedVolume.VolumeObserver {
    private Material matrects;
    private List<Geometry> rectGeometries = new ArrayList<Geometry>();
    private List<Geometry> lines = new ArrayList<Geometry>();
    private Material matLines;
    private boolean beginRectDrawn = false;
    private Geometry endRect;
    private VisualizationMode mode = VisualizationMode.RECT_ON_BEGIN_AND_END;

    public Jme3VolumeVisualization(AssetManager assetManager, Jme3HisClientRenderer jmeApp, Thread renderThread) {
        super(assetManager, jmeApp, renderThread);
        this.build();
    }

    @Override
    public void onVolumeExtended(BrailedVolume brailedVolume, int newNumberOfVolumeParts) {
        Volume v = brailedVolume.getVolumeSubPart(newNumberOfVolumeParts);
        if (v instanceof ConvexBiRectangleVolume) {
            ConvexBiRectangleVolume rv = (ConvexBiRectangleVolume)v;
            switch (this.mode) {
                case RECT_FOR_EACH_STEP: {
                    this.add4LinesBetweenRects(rv.getFirstRect(), rv.getSecondRect());
                    this.addRect(rv.getFirstRect());
                    this.addRect(rv.getSecondRect());
                    break;
                }
                default: {
                    if (!this.beginRectDrawn) {
                        this.beginRectDrawn = true;
                        this.addRect(rv.getFirstRect());
                        this.endRect = this.addRect(rv.getSecondRect());
                    } else {
                        this.renewRectLines(this.endRect, rv.getSecondRect());
                    }
                    this.add4LinesBetweenRects(rv.getFirstRect(), rv.getSecondRect());
                }
            }
        }
    }

    private void add4LinesBetweenRects(Rectangle3D firstRect, Rectangle3D secondRect) {
        final Geometry[] strokeLineGeometrys = new Geometry[4];
        Vector3f[] cornersA = firstRect.getCorners();
        Vector3f[] cornersB = secondRect.getCorners();
        for (int i = 0; i < 4; ++i) {
            Vector3f[] linePoints = new Vector3f[]{cornersA[i], cornersB[i]};
            Line strokeLine = new Line(Mesh.Mode.LineStrip, linePoints);
            strokeLine.setLineWidth(1.0f);
            Geometry strokeLineGeometry = new Geometry("Line", (Mesh)strokeLine);
            strokeLineGeometry.setMaterial(this.matLines);
            this.lines.add(strokeLineGeometry);
            strokeLineGeometrys[i] = strokeLineGeometry;
        }
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                for (Geometry strokeLineGeometry : strokeLineGeometrys) {
                    Jme3VolumeVisualization.this.getRootNode().attachChild((Spatial)strokeLineGeometry);
                }
                return this;
            }
        };
        this.jmeRenderer.enqueue(c);
    }

    private void renewRectLines(final Geometry geo, Rectangle3D r) {
        Vector3f[] corners = r.getCorners();
        Vector3f[] linePoints = new Vector3f[]{corners[0], corners[1], corners[2], corners[3], corners[0]};
        final Line strokeLine = new Line(Mesh.Mode.LineStrip, linePoints);
        strokeLine.setLineWidth(3.0f);
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                geo.setMesh((Mesh)strokeLine);
                return this;
            }
        };
        this.jmeRenderer.enqueue(c);
    }

    private Geometry addRect(Rectangle3D r) {
        Vector3f[] corners = r.getCorners();
        Vector3f[] linePoints = new Vector3f[]{corners[0], corners[1], corners[2], corners[3], corners[0]};
        Line strokeLine = new Line(Mesh.Mode.LineStrip, linePoints);
        strokeLine.setLineWidth(3.0f);
        final Geometry strokeLineGeometry = new Geometry("RectVis", (Mesh)strokeLine);
        strokeLineGeometry.setMaterial(this.matrects);
        this.rectGeometries.add(strokeLineGeometry);
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Jme3VolumeVisualization.this.getRootNode().attachChild((Spatial)strokeLineGeometry);
                return this;
            }
        };
        this.jmeRenderer.enqueue(c);
        return strokeLineGeometry;
    }

    @Override
    public void onVolumeReduced(BrailedVolume brailedVolume) {
    }

    private void build() {
        this.matrects = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.matrects.setColor("Color", ColorRGBA.Magenta);
        this.matLines = this.matrects.clone();
        this.matLines.setColor("Color", ColorRGBA.LightGray);
    }

    public void destroy() {
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                for (Geometry l : Jme3VolumeVisualization.this.lines) {
                    l.removeFromParent();
                }
                Jme3VolumeVisualization.this.lines.clear();
                Jme3VolumeVisualization.this.lines = null;
                for (Geometry r : Jme3VolumeVisualization.this.rectGeometries) {
                    r.removeFromParent();
                }
                Jme3VolumeVisualization.this.rectGeometries.clear();
                Jme3VolumeVisualization.this.rectGeometries = null;
                if (Jme3VolumeVisualization.this.endRect != null) {
                    Jme3VolumeVisualization.this.endRect.removeFromParent();
                    Jme3VolumeVisualization.this.endRect = null;
                }
                Jme3VolumeVisualization.this.getRootNode().removeFromParent();
                return this;
            }
        };
        this.jmeRenderer.enqueue(c);
    }

    private static enum VisualizationMode {
        RECT_FOR_EACH_STEP,
        RECT_ON_BEGIN_AND_END;

    }
}

