/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.jme3;

import com.hybridlab.hyve3d.core.Stroke3D;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Stroke3DSelectionAndTransformationGroup {
    private Set<StrokeGroupObserver> observers = new HashSet<StrokeGroupObserver>(1);
    private Set<Stroke3D> strokesInGroup = new HashSet<Stroke3D>();
    private Map<Stroke3D, Boolean> initialsSet = new HashMap<Stroke3D, Boolean>();
    private Map<Stroke3D, Vector3f> initialStrokePositions = new HashMap<Stroke3D, Vector3f>();
    private Map<Stroke3D, Quaternion> initialStrokeRotations = new HashMap<Stroke3D, Quaternion>();
    private Vector3f pivotPosition = Vector3f.ZERO;
    private Quaternion rotation = Quaternion.DIRECTION_Z;

    public void add(Stroke3D s) {
        this.strokesInGroup.add(s);
        s.setSelected(true);
        for (StrokeGroupObserver o : this.observers) {
            o.onStrokeAddedToGroup(this, s);
        }
    }

    public void remove(Stroke3D s) {
        this.strokesInGroup.remove(s);
        s.setSelected(false);
        for (StrokeGroupObserver o : this.observers) {
            o.onStrokeRemovedFromGroup(this, s);
        }
    }

    public void clear() {
        for (Stroke3D s : this.strokesInGroup) {
            s.setSelected(false);
        }
        this.strokesInGroup.clear();
        this.initialsSet.clear();
        this.initialStrokePositions.clear();
        this.initialStrokeRotations.clear();
        for (StrokeGroupObserver o : this.observers) {
            o.onStrokeGroupWasCleared(this);
        }
    }

    public void addAll(Set<Stroke3D> strokes) {
        this.strokesInGroup.addAll(this.strokesInGroup);
        for (Stroke3D s : strokes) {
            s.setSelected(true);
            for (StrokeGroupObserver o : this.observers) {
                o.onStrokeAddedToGroup(this, s);
            }
        }
    }

    public void setPositionRelativeToBeginTransformationPosition(Vector3f p) {
        for (Stroke3D s : this.strokesInGroup) {
            Vector3f initialStrokePos = this.initialStrokePositions.get(s);
            if (initialStrokePos == null) continue;
            Vector3f newPos = initialStrokePos.add(p);
            s.setPosition(newPos);
        }
    }

    public void setRotationRelativeToBeginTransformationRotation(Quaternion diff) {
        for (Stroke3D s : this.strokesInGroup) {
            Quaternion initialStrokeRot = this.initialStrokeRotations.get(s);
            if (initialStrokeRot == null) continue;
            Quaternion newRot = initialStrokeRot.mult(diff);
            s.setRotation(newRot);
        }
    }

    public void setPivotPosition(Vector3f pos) {
        if (!this.pivotPosition.equals((Object)pos)) {
            System.out.println(String.format("setPivotPosition old=%s new=%s", this.pivotPosition, pos));
            this.pivotPosition = pos;
            for (Stroke3D s : this.strokesInGroup) {
                s.setPivotInSceneSpace(pos);
            }
            for (StrokeGroupObserver o : this.observers) {
                o.onPivotChangedForGroup(this, pos);
            }
        }
    }

    public void beginTransformation() {
        for (Stroke3D s : this.strokesInGroup) {
            this.initialsSet.put(s, true);
            this.initialStrokePositions.put(s, s.getPosition().clone());
            this.initialStrokeRotations.put(s, s.getRotation().clone());
        }
    }

    public void endTransformation() {
        this.initialStrokePositions.clear();
        this.initialStrokeRotations.clear();
    }

    public static interface StrokeGroupObserver {
        public void onStrokeAddedToGroup(Stroke3DSelectionAndTransformationGroup var1, Stroke3D var2);

        public void onStrokeRemovedFromGroup(Stroke3DSelectionAndTransformationGroup var1, Stroke3D var2);

        public void onStrokeGroupWasCleared(Stroke3DSelectionAndTransformationGroup var1);

        public void onPivotChangedForGroup(Stroke3DSelectionAndTransformationGroup var1, Vector3f var2);
    }
}

