/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.core.locations;

import com.hybridlab.hyve3d.core.CamRigPositionAndRotationListener;
import com.hybridlab.hyve3d.core.jme3.Jme3HisClientRenderer;
import com.hybridlab.hyve3d.core.jme3.Jme3SceneObject;
import com.hybridlab.hyve3d.rendering.projection.SixCameraRig;
import com.jme3.asset.AssetManager;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.joda.time.Duration;

public class HydraOrientation
extends Jme3SceneObject
implements CamRigPositionAndRotationListener {
    Quaternion camRigRotation = new Quaternion();
    float headingInDegrees = 0.0f;
    private Set<HydraOrientationListener> listeners = new HashSet<HydraOrientationListener>();

    public HydraOrientation(AssetManager am, Jme3HisClientRenderer r, Thread rt) {
        super(am, r, rt);
        this.updateRootNodeRotation();
    }

    @Override
    public void camRigPositionHasChanged(SixCameraRig camRig) {
        this.rootNode.setLocalTranslation(camRig.getLocalTranslation());
    }

    public void addListener(HydraOrientationListener listener) {
        this.listeners.add(listener);
    }

    public Quaternion getHeadingRotation() {
        Quaternion q = new Quaternion();
        q.fromAngleAxis(this.headingInDegrees * ((float)Math.PI / 180), Vector3f.UNIT_Y);
        return q;
    }

    @Override
    public void camRigRotationHasChanged(SixCameraRig camRig) {
        this.camRigRotation = camRig.getLocalRotation();
        this.updateRootNodeRotation();
    }

    private void updateRootNodeRotation() {
        Quaternion north = this.getHeadingRotation();
        Quaternion myRot = this.camRigRotation.mult(north);
        this.rootNode.setLocalRotation(myRot);
    }

    @Override
    public Node getRootNode() {
        return this.rootNode;
    }

    public void changeHeadingByDegrees(float angleDeg) {
        this.headingInDegrees += angleDeg;
        this.hasChanged();
    }

    private void hasChanged() {
        for (HydraOrientationListener l : this.listeners) {
            l.hydraOrientationHasChanged(this);
        }
        this.updateRootNodeRotation();
    }

    public float getHeadingAngleInDegrees() {
        return this.headingInDegrees;
    }

    public void setHeadingInDegrees(final float degrees) {
        if (!this.jmeRenderer.isThreadEqualToRenderThread(Thread.currentThread())) {
            this.jmeRenderer.enqueue(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    HydraOrientation.this.setHeadingInDegrees(degrees);
                    return null;
                }
            });
            return;
        }
        this.headingInDegrees = degrees;
        this.hasChanged();
    }

    public boolean isVisible() {
        return !this.isHidden();
    }

    @Override
    public void show(Duration transitionDuration) {
        boolean willchange = this.isHidden();
        super.show(transitionDuration);
        if (willchange) {
            this.visibilityHasChanged();
        }
    }

    private void visibilityHasChanged() {
        for (HydraOrientationListener l : this.listeners) {
            l.visibilityHasChanged(this);
        }
    }

    @Override
    public void hide(Duration transitionDuration) {
        boolean willchange = !this.isHidden();
        super.hide(transitionDuration);
        if (willchange) {
            this.visibilityHasChanged();
        }
    }

    public static interface HydraOrientationListener {
        public void hydraOrientationHasChanged(HydraOrientation var1);

        public void visibilityHasChanged(HydraOrientation var1);
    }
}

