/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data;

import com.hybridlab.hyve3d.data.DataModelKey;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;

public abstract class HyveData
implements Serializable {
    private static final long serialVersionUID = 7867583730412722139L;
    private transient PropertyChangeSupport changes;
    private DataModelKey key;

    private HyveData() {
    }

    private PropertyChangeSupport propertyChangeSupport() {
        if (this.changes == null) {
            this.changes = new PropertyChangeSupport(this);
        }
        return this.changes;
    }

    protected HyveData(DataModelKey key) {
        this();
        this.key = key;
    }

    protected void setKey(DataModelKey key) {
        DataModelKey oldValue = this.key;
        this.key = key;
        this.propertyChangeSupport().firePropertyChange("datamodel-instance-key", oldValue, this.key);
    }

    public DataModelKey getKey() {
        return this.key;
    }

    public UUID getId() {
        return null;
    }

    protected void fireIndexedChange(String propertyName, int index, Object oldValue, Object newValue) {
        this.propertyChangeSupport().fireIndexedPropertyChange(this.key.getFullPropertyKeyAsString(propertyName), index, oldValue, newValue);
    }

    protected void fireChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport().firePropertyChange(this.key.getFullPropertyKeyAsString(propertyName), oldValue, newValue);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport().addPropertyChangeListener(this.key.getFullPropertyKeyAsString(propertyName), listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport().removePropertyChangeListener(this.key.getFullPropertyKeyAsString(propertyName), listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport().removePropertyChangeListener(listener);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<? extends HyveData> clazz) {
        try {
            ArrayList<PropertyDescriptor> resultList = new ArrayList<PropertyDescriptor>();
            BeanInfo info = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                if (pd.getName().equals("class")) continue;
                resultList.add(pd);
            }
            PropertyDescriptor[] result = new PropertyDescriptor[resultList.size()];
            return resultList.toArray(result);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            return new PropertyDescriptor[0];
        }
    }
}

