/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.decorators;

import com.hybridlab.hyve3d.data.decorators.SelectableDecorator;
import com.hybridlab.hyve3d.data.domainobjects.Asset;
import com.hybridlab.hyve3d.data.domainobjects.Selectable;
import com.hybridlab.hyve3d.data.valueobjects.BoundingBoxInformation;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.jme3.bounding.BoundingBox;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jogamp.opengl.math.geom.AABBox;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;

public class AssetSelectable
extends SelectableDecorator {
    private Asset asset;
    private static final AABBox nullaabbox = new AABBox(Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN);
    private AABBox aabbox = nullaabbox;
    private BoundingBox originalAABBox;

    public AssetSelectable(Asset asset) {
        super(asset);
        this.asset = asset;
        this.originalAABBox = BoundingBoxInformation.toBoundingBoxInstance(asset.getOriginalBoundingBoxInformation());
        this.calculateAABBox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateAABBox() {
        AABBox aABBox = this.aabbox;
        synchronized (aABBox) {
            if (this.originalAABBox == null) {
                this.aabbox = nullaabbox;
                return;
            }
            if (this.originalAABBox != null) {
                Vector3f min = new Vector3f();
                Vector3f max = new Vector3f();
                this.originalAABBox.getMin(min);
                this.originalAABBox.getMax(max);
                Transformation t = this.asset.getTransformation();
                min = t.mult(min);
                max = t.mult(max);
                BoundingBox bb = new BoundingBox(min, max);
                AABBox old = this.aabbox;
                min = bb.getMin(min);
                max = bb.getMax(max);
                AABBox newbox = new AABBox(min.x, min.y, min.z, max.x, max.y, max.z);
                if (!old.equals((Object)newbox)) {
                    this.aabbox = newbox;
                    this.fireBoundsChange();
                } else {
                    Logger.getAnonymousLogger().warning("the aabbox did not change, but was recalculated for: " + this.asset.toString());
                }
            } else {
                Logger.getAnonymousLogger().severe("cant calculate AABBOX for asset: " + this.asset.toString());
            }
        }
    }

    @Override
    public UUID getId() {
        return this.asset.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AABBox getAABBox() {
        AABBox aABBox = this.aabbox;
        synchronized (aABBox) {
            return this.aabbox;
        }
    }

    @Override
    public List<Vector3f> getPointsInSceneCoordinates() {
        ArrayList<Vector3f> points = new ArrayList<Vector3f>();
        points.add(this.asset.getTransformation().getPosition());
        return points;
    }

    @Override
    public void setSelected(boolean b) {
        this.asset.setSelected(b);
    }

    @Override
    public Boolean isCurrentlySelectable() {
        return this.asset.getIsSelectable();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.asset) {
            String prop = evt.getPropertyName();
            if (!(evt instanceof IndexedPropertyChangeEvent)) {
                if (prop.endsWith("transformation")) {
                    this.calculateAABBox();
                } else if (!prop.endsWith("selected") && prop.endsWith("originalAABBInformation")) {
                    this.originalAABBox = BoundingBoxInformation.toBoundingBoxInstance(this.asset.getOriginalBoundingBoxInformation());
                    this.calculateAABBox();
                    String s = String.format("calculateAABBox: aabbox=%s \n", this.getAABBox().toString());
                    System.out.println(s);
                }
            }
        }
    }

    @Override
    public Transform getTransformation() {
        return this.asset.getTransformation().toTransform();
    }

    @Override
    public void setTransformation(Transform trf) {
        Transformation transformation = new Transformation(trf);
        this.asset.setTransformation(transformation);
    }

    @Override
    public Selectable.ButterFlyNetCriteria getButterFlyNetSelectionCriteria() {
        return Selectable.ButterFlyNetCriteria.ButterFlyVolumeIntersectsBoundingBoxOfSelectable;
    }
}

