/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.domainobjects;

import com.hybridlab.hyve3d.data.DataModelKey;
import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.hyve.undoredo.Executable;
import com.hybridlab.hyve3d.hyve.undoredo.StrokeCreationCommand;
import com.hybridlab.hyve3d.hyve.undoredo.UndoRedoAble;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

@com.jme3.network.serializing.Serializable
public class CommandHistory
extends HyveData
implements Serializable {
    private static final long serialVersionUID = -5827657998785339117L;
    public static boolean useCommandHistoryInterconnected = false;
    private Integer position = -1;
    private LinkedHashMap<Integer, Executable> commands = new LinkedHashMap();
    private Set<UUID> usedBy = new HashSet<UUID>();
    private transient Logger logger;
    private transient Set<StateListener> stateListeners;
    private UUID undoRedoStrokeInfo = null;

    public CommandHistory() {
        super(DataModelKey.createWithKeyParts("CommandHistory"));
    }

    public CommandHistory(UUID id) {
        super(DataModelKey.createWithKeyParts("CommandHistory", id.toString()));
    }

    public Executable getCommand(int index) {
        return this.commands.get(index);
    }

    public void setCommand(int index, Executable cmd) {
        String cmdToString = cmd == null ? "null" : cmd.toString();
        String info = String.format("%s, %s", index, cmdToString);
        this.getLogger().info(info);
        UndoRedoAble old = this.commands.get(index);
        this.commands.put(index, cmd);
        this.fireIndexedChange("command", index, old, cmd);
        if (cmd == null) {
            this.commands.remove(index);
        }
    }

    private Set<StateListener> getStateListener() {
        if (this.stateListeners == null) {
            this.stateListeners = new HashSet<StateListener>();
        }
        return this.stateListeners;
    }

    public void addStateListener(StateListener c) {
        this.getStateListener().add(c);
    }

    public void removeStateListener(StateListener c) {
        this.getStateListener().remove(c);
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(CommandHistory.class.getName());
        }
        return this.logger;
    }

    public Integer getHistoryPosition() {
        return this.position;
    }

    public void setHistoryPosition(Integer newposition) {
        Integer old = this.position;
        this.position = newposition;
        String info = String.format("historyPosition old=%s new=%s", old == null ? "null" : String.valueOf(old), this.position == null ? "null" : String.valueOf(this.position));
        this.getLogger().info(info);
        this.fireChange("historyPosition", old, this.position);
        this.updateExecutedState(old, this.position);
        this.updateListeners();
    }

    private void updateExecutedState(Integer old, Integer newPos) {
        block3: {
            block2: {
                if (old >= newPos) break block2;
                for (int i = old.intValue(); i <= newPos; ++i) {
                    Executable cmd;
                    if (i < 0 || (cmd = this.getCommand(i)) == null) continue;
                    cmd.setIsExecuted(true);
                }
                break block3;
            }
            if (old <= newPos) break block3;
            for (int i = old.intValue(); i > newPos; --i) {
                Executable cmd;
                if (i < 0 || (cmd = this.getCommand(i)) == null) continue;
                cmd.setIsExecuted(false);
            }
        }
    }

    private void updateListeners() {
        if (this.getStateListener().isEmpty()) {
            return;
        }
        String undoInfo = this.getUndoInfo();
        String redoInfo = this.getRedoInfo();
        boolean hasRedos = redoInfo != null;
        boolean hasUndos = undoInfo != null;
        for (StateListener l : this.getStateListener()) {
            l.onStateChanged(hasUndos, hasRedos);
            l.onInfoAvailable(undoInfo, redoInfo);
        }
    }

    private String getRedoInfo() {
        if (this.hasRedos()) {
            Executable redocmd = this.getCommand(this.position + 1);
            return redocmd.getDescription();
        }
        return null;
    }

    private String getUndoInfo() {
        if (this.hasUndo()) {
            Executable undocmd = this.getCommand(this.position);
            return undocmd.getDescription();
        }
        return null;
    }

    public void add_AndExecuteIfNotYetExecuted(Executable cmd) {
        this.removePossibleRedos();
        Integer index = this.getNextIndex();
        this.setCommand(index, cmd);
        if (cmd.hasExecutor() && !cmd.isExecuted()) {
            cmd.execute();
        }
        this.setHistoryPosition(index);
    }

    private void removePossibleRedos() {
        if (this.hasRedos()) {
            int minIndex = this.position + 1;
            int maxIndex = this.commands.size() - 1;
            for (int index = minIndex; index <= maxIndex; ++index) {
                this.setCommand(index, null);
            }
        }
    }

    private Integer getNextIndex() {
        return this.commands.size();
    }

    public void addUsage(UUID id) {
        HashSet<UUID> usedByCopy = new HashSet<UUID>(this.usedBy);
        usedByCopy.add(id);
        this.setUsedBySet(usedByCopy);
    }

    public void removeUsage(UUID id) {
        HashSet<UUID> usedByCopy = new HashSet<UUID>(this.usedBy);
        usedByCopy.remove(id);
        this.setUsedBySet(usedByCopy);
    }

    public void setUsedBySet(Set<UUID> set) {
        Set<UUID> old = this.usedBy;
        this.usedBy = set;
        this.fireChange("usedBySet", old, this.usedBy);
    }

    public Set<UUID> getUsedBySet() {
        return this.usedBy;
    }

    public boolean isUsedBy(UUID id) {
        if (id == null) {
            return false;
        }
        if (this.usedBy == null) {
            this.usedBy = new HashSet<UUID>();
        }
        return this.usedBy.contains(id);
    }

    public boolean redo() {
        if (this.hasRedos()) {
            Executable undocmd = this.getCommand(this.position + 1);
            if (undocmd instanceof StrokeCreationCommand) {
                StrokeCreationCommand scc = (StrokeCreationCommand)undocmd;
                System.out.println("Redo was called in Commandhistory (for a StrokeCreationCommand): \n getDescription: \n" + scc.getDescription() + " \n getStrokeId: \n" + scc.getStrokeId() + " \n");
                this.undoRedoStrokeInfo = scc.getStrokeId();
                this.setUndoRedoStrokeInfo(this.undoRedoStrokeInfo);
            } else {
                this.setUndoRedoStrokeInfo(null);
            }
            try {
                undocmd.redo();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.setHistoryPosition(this.position + 1);
            return true;
        }
        return false;
    }

    private boolean hasRedos() {
        return this.position < this.commands.size() - 1;
    }

    private boolean hasUndo() {
        return this.position >= 0;
    }

    private void setUndoRedoStrokeInfo(UUID undoRedoStrokeInfo) {
        this.undoRedoStrokeInfo = undoRedoStrokeInfo;
    }

    public boolean lastUndoOrRedoWasAStrokeCommand() {
        return this.undoRedoStrokeInfo != null;
    }

    public UUID getLastUnDoneOrRedoneStrokeCommandInfos() {
        return this.undoRedoStrokeInfo;
    }

    public int getNumberOfPossibleRedos() {
        return Math.max(0, this.commands.size() - this.position - 1);
    }

    public int getNumberOfPossibleUndos() {
        return this.position;
    }

    public boolean undo() {
        if (this.hasUndo()) {
            Executable undocmd = this.getCommand(this.position);
            try {
                if (undocmd instanceof StrokeCreationCommand) {
                    StrokeCreationCommand scc = (StrokeCreationCommand)undocmd;
                    System.out.println("Redo was called in Commandhistory (for a StrokeCreationCommand): \n getDescription: \n" + scc.getDescription() + " \n getStrokeId: \n" + scc.getStrokeId() + " \n");
                    this.undoRedoStrokeInfo = scc.getStrokeId();
                    this.setUndoRedoStrokeInfo(this.undoRedoStrokeInfo);
                } else {
                    this.setUndoRedoStrokeInfo(null);
                }
                undocmd.undo();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.setHistoryPosition(this.position - 1);
            return true;
        }
        return false;
    }

    public void clear() {
        int minIndex = 0;
        int maxIndex = this.commands.size() - 1;
        this.position = -1;
        for (int index = minIndex; index <= maxIndex; ++index) {
            this.setCommand(index, null);
        }
        this.setHistoryPosition(this.position);
        this.setUndoRedoStrokeInfo(null);
    }

    public static interface StateListener {
        public void onStateChanged(boolean var1, boolean var2);

        public void onInfoAvailable(String var1, String var2);
    }
}

