/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.synch;

import com.hybridlab.hyve3d.data.synch.SessionSynchConnection;
import com.hybridlab.hyve3d.data.synch.SessionSynchConnectionEndPoint;
import com.hybridlab.hyve3d.data.synch.SynchConnectionEndPoint;
import com.hybridlab.hyve3d.data.synch.Synchronizer;
import com.hybridlab.hyve3d.data.synch.messages.SynchMessage;
import com.hybridlab.hyve3d.hyve.SessionInfo;
import java.util.UUID;
import java.util.logging.Logger;

public class CleverSessionSynchConnection
implements SessionSynchConnection {
    private Synchronizer localSynchronizer;
    private SessionSynchConnectionEndPoint endpoint;
    private SessionInfo sessionInfo;
    private UUID connId = UUID.randomUUID();

    public CleverSessionSynchConnection(SessionInfo sessionInfo) {
        this.sessionInfo = sessionInfo;
    }

    @Override
    public UUID getConnectionId() {
        return this.connId;
    }

    @Override
    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    @Override
    public void connectToEndPoint(SynchConnectionEndPoint p) {
        throw new RuntimeException("not implemented");
    }

    public String toString() {
        return CleverSessionSynchConnection.class.getSimpleName() + " <" + this.hashCode() + "> [sessionId=" + this.sessionInfo.id + ", connId=" + this.connId + "]";
    }

    @Override
    public void connectToEndPoint(SessionSynchConnectionEndPoint p) {
        this.endpoint = p;
        this.endpoint.addConnection(this);
    }

    @Override
    public void setLocalSynchronizer(Synchronizer dataModelSynchronizer) {
        this.localSynchronizer = dataModelSynchronizer;
    }

    @Override
    public void send(SynchMessage m) {
        if (this.endpoint != null) {
            this.endpoint.relayMessageFromConnection(m, this);
        } else {
            Logger.getAnonymousLogger().severe("no endpoint set! (" + this.toString() + ")");
        }
    }

    @Override
    public void receive(SynchMessage m) {
        if (this.localSynchronizer != null) {
            this.localSynchronizer.receiveSynchMessage(this, m);
        }
    }

    @Override
    public UUID getSessionId() {
        return this.sessionInfo.id;
    }

    @Override
    public boolean isModelFollowing() {
        return this.localSynchronizer.isDataModelFollowing();
    }
}

