/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.synch.messages;

import com.hybridlab.hyve3d.data.synch.messages.SynchMessage;
import com.hybridlab.hyve3d.network.interconnection.messages.SessionSynchMessage;
import com.jme3.network.serializing.Serializable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;

@Serializable
public class ChunkedSynchMessage
extends SessionSynchMessage {
    public UUID messageid;
    public int numchunks;
    public int chunkid;
    public int totalsize;
    public byte[] data;
    public static transient int splitThreshold = 30000;
    private static transient int maxChunkSize = 31761;

    public ChunkedSynchMessage() {
    }

    public ChunkedSynchMessage(UUID sessionid, UUID messageid, int numchunks, int chunkid, byte[] data, int totalsize) {
        super(sessionid);
        this.messageid = messageid;
        this.numchunks = numchunks;
        this.chunkid = chunkid;
        this.data = data;
        this.totalsize = totalsize;
    }

    public static ChunkedSynchMessage[] split(SynchMessage bigMessage, UUID sessionId) {
        byte[] chunk;
        int endIndexExclusive;
        int startIndexInclusive;
        byte[] data = ChunkedSynchMessage.serializeToBytes(bigMessage);
        int totalsize = data.length;
        int modulo = totalsize % maxChunkSize;
        int smallChunk = modulo == 0 ? 0 : 1;
        int numEqualChunks = totalsize / maxChunkSize;
        int numTotalChunks = numEqualChunks + smallChunk;
        ChunkedSynchMessage[] chunks = new ChunkedSynchMessage[numEqualChunks + smallChunk];
        UUID mid = UUID.randomUUID();
        int c = 0;
        for (c = 0; c < numEqualChunks; ++c) {
            startIndexInclusive = c * maxChunkSize;
            endIndexExclusive = startIndexInclusive + maxChunkSize;
            chunk = ArrayUtils.subarray(data, startIndexInclusive, endIndexExclusive);
            chunks[c] = new ChunkedSynchMessage(sessionId, mid, numTotalChunks, c, chunk, totalsize);
        }
        if (smallChunk == 1) {
            startIndexInclusive = c * maxChunkSize;
            endIndexExclusive = startIndexInclusive + modulo;
            chunk = ArrayUtils.subarray(data, startIndexInclusive, endIndexExclusive);
            chunks[c] = new ChunkedSynchMessage(sessionId, mid, numTotalChunks, c, chunk, totalsize);
        }
        return chunks;
    }

    public static SynchMessage join(ChunkedSynchMessage[] chunks) throws IllegalArgumentException, Exception {
        if (chunks == null) {
            throw new IllegalArgumentException("chunk array must not be null");
        }
        if (chunks.length == 0) {
            throw new IllegalArgumentException("at least one chunk must be in the array");
        }
        ChunkedSynchMessage first = chunks[0];
        int numchunks = first.numchunks;
        int totalsize = first.totalsize;
        UUID mid = first.messageid;
        if (chunks.length != numchunks) {
            throw new IllegalArgumentException("chunks are missing");
        }
        byte[] data = new byte[totalsize];
        for (int c = 0; c < numchunks; ++c) {
            if (chunks[c] == null) {
                throw new Exception("Missing chunk at position " + c + " of the chunks array!");
            }
            if (!mid.equals(chunks[c].messageid)) {
                throw new Exception("Found a chunk with a wrong message-uuid!");
            }
            if (chunks[c].chunkid != c) {
                throw new Exception("Chunk order mismatch!");
            }
            System.arraycopy(chunks[c].data, 0, data, c * maxChunkSize, chunks[c].data.length);
        }
        SynchMessage m = ChunkedSynchMessage.deserialize(data);
        return m;
    }

    private static byte[] serializeToBytes(SynchMessage m) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            ObjectOutputStream output = new ObjectOutputStream(buffer);
            output.writeObject(m);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer.toByteArray();
    }

    private static SynchMessage deserialize(byte[] ser) {
        try {
            ByteArrayInputStream buffer = new ByteArrayInputStream(ser);
            ObjectInputStream input = new ObjectInputStream(buffer);
            SynchMessage m = (SynchMessage)input.readObject();
            return m;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }
}

