/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.synch.messages;

import com.hybridlab.hyve3d.data.DataModelKey;
import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.data.synch.messages.DataRemoveMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

@com.jme3.network.serializing.Serializable
public class DataAddMessage
extends DataRemoveMessage
implements Serializable {
    private static final long serialVersionUID = -1031247286721812589L;
    private byte[] bytedata;
    private transient HyveData cachedData = null;
    private static transient boolean useCachedInstance = false;

    @Override
    public String toString() {
        return "DataAddMessage [key=" + this.getKey() + ", bytedata.length=" + this.bytedata.length + "]";
    }

    @Override
    public int getSize() {
        return this.bytedata.length;
    }

    public DataAddMessage() {
    }

    public DataAddMessage(DataModelKey key, HyveData data) {
        super(key);
        if (useCachedInstance) {
            this.cachedData = data;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            ObjectOutputStream output = new ObjectOutputStream(buffer);
            output.writeObject(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.bytedata = buffer.toByteArray();
    }

    public HyveData getData() {
        HyveData data = this.cachedData;
        if (useCachedInstance && data != null) {
            return data;
        }
        ByteArrayInputStream buffer = new ByteArrayInputStream(this.bytedata);
        try {
            ObjectInputStream input = new ObjectInputStream(buffer);
            data = (HyveData)input.readObject();
            if (useCachedInstance) {
                this.cachedData = data;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return data;
    }
}

