/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.synch.messages;

import com.hybridlab.hyve3d.data.synch.messages.SynchMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

@com.jme3.network.serializing.Serializable
public class PropertyChangeMessage
extends SynchMessage
implements Serializable {
    private static final long serialVersionUID = 1795270170153002928L;
    private String propertyname;
    private static transient boolean useCachedInstance = true;
    private transient Object cached;
    private boolean isNullValue = false;
    private byte[] bytedata;

    public String toString() {
        try {
            Object nv = this.getNewValue();
            return "PropertyChangeMessage [propertyname=" + this.propertyname + ", getNewValue()=" + (nv == null ? "null" : nv) + ", isReliable()=" + this.isReliable() + "]";
        }
        catch (Exception e) {
            return super.toString() + "\n" + e.getMessage();
        }
    }

    @Override
    public int getSize() {
        if (this.isNullValue) {
            return 0;
        }
        return this.bytedata.length;
    }

    public PropertyChangeMessage() {
    }

    public PropertyChangeMessage(String propertyname, Object n) {
        this.propertyname = propertyname;
        if (n == null) {
            this.isNullValue = true;
            this.bytedata = new byte[0];
        } else {
            if (useCachedInstance) {
                this.cached = n;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try {
                ObjectOutputStream output = new ObjectOutputStream(buffer);
                output.writeObject(n);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.bytedata = buffer.toByteArray();
        }
    }

    public String getPropertyName() {
        return this.propertyname;
    }

    public Object getNewValue() {
        if (this.isNullValue) {
            return null;
        }
        Object newValue = this.cached;
        if (useCachedInstance && newValue != null) {
            return newValue;
        }
        ByteArrayInputStream buffer = new ByteArrayInputStream(this.bytedata);
        try {
            ObjectInputStream input = new ObjectInputStream(buffer);
            newValue = input.readObject();
            if (useCachedInstance) {
                this.cached = newValue;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return newValue;
    }
}

