/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.valueobjects;

import com.jme3.bounding.BoundingBox;
import com.jme3.math.Vector3f;
import java.io.Serializable;

@com.jme3.network.serializing.Serializable
public class BoundingBoxInformation
implements Serializable {
    private static final long serialVersionUID = 6231031938454400126L;
    private String type = "aabb";
    private Vector3f max = Vector3f.NAN;
    private Vector3f min = Vector3f.NAN;

    public static BoundingBoxInformation fromBBox(BoundingBox bbox) {
        BoundingBoxInformation bbi = new BoundingBoxInformation();
        bbi.type = "aabb";
        bbi.min = bbox.getMin(null);
        bbi.max = bbox.getMax(null);
        return bbi;
    }

    public BoundingBoxInformation copy() {
        BoundingBoxInformation c = new BoundingBoxInformation();
        c.type = this.type;
        c.min = this.min.clone();
        c.max = this.max.clone();
        return c;
    }

    public static BoundingBox toBoundingBoxInstance(BoundingBoxInformation bbinfo) {
        if (bbinfo == null) {
            return null;
        }
        Vector3f min = bbinfo.min;
        Vector3f max = bbinfo.max;
        BoundingBox bb = new BoundingBox(min, max);
        return bb;
    }
}

