/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.data.valueobjects;

import com.hybridlab.utils.math.MathUtils;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import java.io.Serializable;

public class Transformation
implements Serializable {
    private static final long serialVersionUID = 5374027517718375825L;
    private Quaternion rotation;
    private Vector3f position;
    private Vector3f scale;

    public String toString() {
        return "Transformation [position=" + this.position + ", rotation=" + MathUtils.quaternionToAxisAngleInDegreesString(this.rotation) + " scale=" + String.valueOf(this.scale) + "]";
    }

    public Transformation() {
        this(new Vector3f(), new Quaternion(), new Vector3f(1.0f, 1.0f, 1.0f));
    }

    public Transformation(Vector3f position, Quaternion rotation) {
        this(position, rotation, new Vector3f(1.0f, 1.0f, 1.0f));
    }

    public Transformation(Vector3f position, Quaternion rotation, Vector3f scale) {
        this.rotation = rotation;
        this.position = position;
        this.scale = scale;
    }

    public Transformation(Transform trf) {
        this(trf.getTranslation(), trf.getRotation(), trf.getScale());
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public Vector3f getScale() {
        return this.scale;
    }

    public Quaternion getRotation() {
        return this.rotation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        result = 31 * result + (this.rotation == null ? 0 : this.rotation.hashCode());
        result = 31 * result + (this.scale == null ? 0 : this.scale.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Transformation other = (Transformation)obj;
        if (this.position == null ? other.position != null : !this.position.equals((Object)other.position)) {
            return false;
        }
        if (this.rotation == null ? other.rotation != null : !this.rotation.equals((Object)other.rotation)) {
            return false;
        }
        return !(this.scale == null ? other.scale != null : !this.scale.equals((Object)other.scale));
    }

    public Transformation add(Vector3f direction) {
        Vector3f newPos = this.getPosition().add(direction);
        return new Transformation(newPos, this.rotation.clone());
    }

    public Transformation copy() {
        return new Transformation(this.position.clone(), this.rotation.clone(), this.scale.clone());
    }

    public void addLocal(Vector3f moveAmount) {
        this.position = this.position.add(moveAmount);
    }

    public void changeRotationTo(Quaternion rotation) {
        this.rotation = rotation;
    }

    public static Transformation interpolate(Transformation begin, Transformation end, float t) {
        if (begin == null || end == null) {
            throw new IllegalArgumentException("Transformations must not be null");
        }
        Vector3f p = begin.getPosition().add(end.getPosition().subtract(begin.getPosition()).mult(t));
        Quaternion r = new Quaternion();
        r = r.slerp(begin.getRotation(), end.getRotation(), t);
        return new Transformation(p, r);
    }

    public Transform toTransform() {
        return new Transform(this.position.clone(), this.rotation.clone(), this.scale.clone());
    }

    public Vector3f mult(Vector3f v) {
        Vector3f r = v.clone();
        this.rotation.multLocal(r);
        r.multLocal(this.scale);
        r.addLocal(this.position);
        return r;
    }
}

