/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.files;

import com.hybridlab.hyve3d.data.domainobjects.Asset;
import com.hybridlab.hyve3d.data.domainobjects.Sky;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.files.HyveFileUtilities;
import com.hybridlab.hyve3d.files.ObjInformation;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AssetData {
    private static final String KEY_TYPE = "assettype";
    private static final String KEY_PATH = "path";
    private static final String KEY_FILE = "file";
    private static final String KEY_ORIGINAL_PATH = "originalpath";
    private static final String KEY_ORIGINAL_FILE = "originalfile";
    private static final String KEY_DEPENDENT_FILES = "dependentfiles";
    private static final String KEY_IMPORTOPTIONS = "importoptions";
    private static final String KEY_TRANSFORMATION = "transformation";
    private static final String KEY_ASSET_ORIGIN_HYVE_UUID = "originehyveuuid";
    private static final String KEY_ASSET_UUID = "assetuuid";
    private Set<File> dependencies = new HashSet<File>();
    private Asset asset;
    private boolean analyzed = false;
    private JSONObject json = new JSONObject();

    private AssetData() {
    }

    public static AssetData AssetToData(Asset a) {
        AssetData ad = new AssetData();
        ad.asset = a;
        return ad;
    }

    private void analyze() {
        try {
            this.doTheActualAnalyze();
        }
        catch (JSONException e) {
            throw new IllegalStateException("analyze failed", e);
        }
    }

    public static AssetData fromAssetJsonString(String json, File directoryOfHyveFile) {
        try {
            return AssetData.parseJson(json, directoryOfHyveFile);
        }
        catch (JSONException e) {
            throw new IllegalStateException("parseJson failed", e);
        }
    }

    private static AssetData parseJson(String jsonString, File directoryOfHyveFile) throws JSONException {
        AssetData ad = new AssetData();
        JSONObject json = new JSONObject(jsonString);
        Asset.Type type = Asset.Type.valueOf(json.getString(KEY_TYPE));
        String path = json.getString(KEY_PATH);
        String file = json.getString(KEY_FILE);
        Object dir = directoryOfHyveFile.getAbsolutePath();
        if (!((String)dir).endsWith("/")) {
            dir = (String)dir + "/";
        }
        String completepath = (String)dir + path;
        String importOptions = json.getString(KEY_IMPORTOPTIONS);
        UUID originhyveId = UUID.fromString(json.getString(KEY_ASSET_ORIGIN_HYVE_UUID));
        UUID assetId = UUID.fromString(json.getString(KEY_ASSET_UUID));
        JSONArray df = json.optJSONArray(KEY_DEPENDENT_FILES);
        ArrayList<String> dfl = new ArrayList<String>();
        if (df != null) {
            for (int index = 0; index < df.length(); ++index) {
                dfl.add(df.getString(index));
            }
        }
        Asset a = null;
        switch (type) {
            default: {
                a = new Asset(assetId, originhyveId, type, completepath, file, importOptions);
                break;
            }
            case Sky: {
                a = new Sky(assetId, Sky.SourceType.DDS, originhyveId, type, completepath, file, importOptions);
            }
        }
        a.setDependentFiles(dfl);
        a.setTransformation(AssetData.fromJsonObject(json.getJSONObject(KEY_TRANSFORMATION)));
        ad.asset = a;
        return ad;
    }

    private void doTheActualAnalyze() throws JSONException {
        if (this.asset == null) {
            throw new IllegalStateException("no asset is set");
        }
        this.json = new JSONObject();
        this.json.put(KEY_TYPE, (Object)this.asset.getType().toString());
        this.json.put(KEY_ASSET_UUID, (Object)this.asset.getId().toString());
        this.json.put(KEY_ASSET_ORIGIN_HYVE_UUID, (Object)this.asset.getOriginHyveID().toString());
        String importOptions = this.asset.getImportOptions();
        this.json.put(KEY_IMPORTOPTIONS, (Object)importOptions);
        this.json.put(KEY_TRANSFORMATION, (Object)AssetData.toJsonObject(this.asset.getTransformation()));
        switch (this.asset.getType()) {
            case OBJ: {
                String p = this.asset.getPath();
                String f = this.asset.getFile();
                this.json.put(KEY_ORIGINAL_PATH, (Object)p);
                this.json.put(KEY_ORIGINAL_FILE, (Object)f);
                File objFile = new File(this.asset.getPath(), this.asset.getFile());
                this.dependencies.add(objFile);
                try {
                    List<String> files = ObjInformation.getDependentFiles(objFile);
                    String s = "----------------------------------------------------\n>> dependent files for " + objFile.getAbsolutePath() + "\n----- " + files.size() + " --------------------\n";
                    for (String df : files) {
                        File dependentFile = new File(this.asset.getPath(), df);
                        this.dependencies.add(dependentFile);
                        s = s + "   " + dependentFile.getAbsolutePath() + "\n";
                    }
                    this.json.put(KEY_DEPENDENT_FILES, files);
                    System.out.println(s);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case OBJ_ZIPPED: 
            case OgreZip: 
            case Sky: 
            case PointCloud: {
                String p = this.asset.getPath();
                String f = this.asset.getFile();
                this.json.put(KEY_ORIGINAL_PATH, (Object)p);
                this.json.put(KEY_ORIGINAL_FILE, (Object)f);
                this.dependencies.add(new File(this.asset.getPath(), this.asset.getFile()));
                break;
            }
            default: {
                throw new IllegalStateException("asset type unhandled");
            }
        }
        this.analyzed = true;
    }

    private static JSONObject toJsonObject(Transformation transformation) throws JSONException {
        JSONObject jt = new JSONObject();
        Vector3f pos = transformation.getPosition();
        jt.put("pos", (Object)new JSONArray((Object)new float[]{pos.x, pos.y, pos.z}));
        Vector3f scale = transformation.getScale();
        jt.put("scale", (Object)new JSONArray((Object)new float[]{scale.x, scale.y, scale.z}));
        Quaternion q = transformation.getRotation();
        jt.put("rot", (Object)new JSONArray((Object)new float[]{q.getX(), q.getY(), q.getZ(), q.getW()}));
        return jt;
    }

    private static Transformation fromJsonObject(JSONObject jt) throws JSONException {
        Vector3f pos = new Vector3f();
        Vector3f scale = new Vector3f();
        Quaternion rot = new Quaternion();
        JSONArray posArray = jt.getJSONArray("pos");
        pos.x = Float.parseFloat(String.valueOf(posArray.get(0)));
        pos.y = Float.parseFloat(String.valueOf(posArray.get(1)));
        pos.z = Float.parseFloat(String.valueOf(posArray.get(2)));
        JSONArray scaleArray = jt.getJSONArray("scale");
        scale.x = Float.parseFloat(String.valueOf(scaleArray.get(0)));
        scale.y = Float.parseFloat(String.valueOf(scaleArray.get(1)));
        scale.z = Float.parseFloat(String.valueOf(scaleArray.get(2)));
        JSONArray rotArray = jt.getJSONArray("rot");
        rot.set(Float.parseFloat(String.valueOf(rotArray.get(0))), Float.parseFloat(String.valueOf(rotArray.get(1))), Float.parseFloat(String.valueOf(rotArray.get(2))), Float.parseFloat(String.valueOf(rotArray.get(3))));
        return new Transformation(pos, rot, scale);
    }

    public static Asset DataToAsset(AssetData assetData) {
        if (assetData.hasDependentFiles()) {
            ArrayList<String> dfl = new ArrayList<String>();
            for (File df : assetData.getDependentFiles()) {
                dfl.add(df.getName());
            }
            assetData.asset.setDependentFiles(dfl);
        }
        return assetData.asset;
    }

    public String toAssetJsonString() {
        if (!this.analyzed) {
            this.analyze();
        }
        try {
            String importOptions = this.json.getString(KEY_IMPORTOPTIONS);
            JSONObject iO = new JSONObject(importOptions);
            iO.put("selectable", this.asset.getIsSelectable());
            this.json.put(KEY_IMPORTOPTIONS, (Object)iO.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.json.toString();
    }

    public Set<File> getDependentFiles() {
        if (!this.analyzed) {
            this.analyze();
        }
        return Collections.unmodifiableSet(this.dependencies);
    }

    public boolean hasDependentFiles() {
        if (!this.analyzed) {
            this.analyze();
        }
        return !this.dependencies.isEmpty();
    }

    public String copyDependendFilesAndReLink(File hyveFileSaveFolder) throws IOException, JSONException {
        String assetFolderName = this.asset.getId().toString();
        File assetFolder = new File(hyveFileSaveFolder.getAbsolutePath(), assetFolderName);
        ArrayList<String> errors = new ArrayList<String>();
        for (File source : this.getDependentFiles()) {
            File destination = new File(assetFolder.getAbsolutePath(), source.getName());
            try {
                HyveFileUtilities.copyFile(source, destination);
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
                errors.add(fnfe.getLocalizedMessage());
            }
        }
        this.json.put(KEY_PATH, (Object)this.asset.getId().toString());
        this.json.put(KEY_FILE, (Object)this.asset.getFile());
        return assetFolderName;
    }
}

