/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.files;

import com.momchil_atanasov.data.front.error.WFException;
import com.momchil_atanasov.data.front.parser.MTLLibrary;
import com.momchil_atanasov.data.front.parser.MTLMaterial;
import com.momchil_atanasov.data.front.parser.MTLParser;
import com.momchil_atanasov.data.front.parser.OBJModel;
import com.momchil_atanasov.data.front.parser.OBJParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ObjInformation {
    public static List<String> getDependentFiles(File obj) throws WFException, IOException {
        ArrayList<String> dependentFiles = new ArrayList<String>();
        FileInputStream in = new FileInputStream(obj);
        OBJParser parser = new OBJParser();
        OBJModel model = parser.parse(in);
        List<String> matlibs = model.getMaterialLibraries();
        MTLParser matparser = new MTLParser();
        for (String mtlFile : matlibs) {
            dependentFiles.add(mtlFile);
            File mf = new File(obj.getParent(), mtlFile);
            FileInputStream matin = new FileInputStream(mf);
            MTLLibrary matlib = matparser.parse(matin);
            for (MTLMaterial m : matlib.getMaterials()) {
                ObjInformation.addIfNotNull(m.getAmbientTexture(), dependentFiles);
                ObjInformation.addIfNotNull(m.getDiffuseTexture(), dependentFiles);
                ObjInformation.addIfNotNull(m.getDissolveTexture(), dependentFiles);
                ObjInformation.addIfNotNull(m.getSpecularExponentTexture(), dependentFiles);
                ObjInformation.addIfNotNull(m.getSpecularTexture(), dependentFiles);
            }
        }
        return dependentFiles;
    }

    private static void addIfNotNull(String tex, List<String> texturesFiles) {
        if (tex != null) {
            texturesFiles.add(tex);
        }
    }
}

