/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.files;

import com.hybridlab.hyve3d.core.Stroke3D;
import com.hybridlab.hyve3d.core.Stroke3DPoint;
import com.hybridlab.hyve3d.core.StrokeInk;
import com.hybridlab.hyve3d.data.Session;
import com.hybridlab.hyve3d.files.STLExportParameter;
import com.hybridlab.hyve3d.files.StrokeConverter;
import com.hybridlab.utils.Interpolation;
import com.jme3.math.Quaternion;
import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class STLExportDocument {
    private StringBuilder export;
    private Format format = Format.ASCII;
    private STLExportParameter exportParameter;

    public STLExportDocument(STLExportParameter options) {
        this.exportParameter = options;
    }

    public void save(File f) throws IOException {
        FileUtils.writeStringToFile(f, this.export.toString());
    }

    public void setFormat(Format f) {
        this.format = f;
    }

    public void exportStrokesIntoDocument(Session session) {
        Set<Stroke3D> allStrokes = StrokeConverter.convertStrokes(session.getAllStrokes());
        this.export = new StringBuilder();
        int subdivision = this.exportParameter.getSubdivisionAxis();
        float thicknessFactor = this.exportParameter.getThicknessFactor();
        for (Stroke3D stroke : allStrokes) {
            if (stroke.getNumberOfPoints() <= 0) continue;
            switch (this.format) {
                default: 
            }
            this.writeLn("solid " + stroke.getId().toString());
            StrokePipeTriangularization pipe = new StrokePipeTriangularization(stroke, subdivision, thicknessFactor);
            List<Triangle> tris = pipe.getTriangles();
            for (Triangle t : tris) {
                Vector3f[] verts;
                Vector3f normal = t.getNormal();
                switch (this.format) {
                    default: 
                }
                this.writeLn("facet normal " + this.formatFloat(normal.x) + " " + this.formatFloat(normal.y) + " " + this.formatFloat(normal.z));
                this.writeLn(" outer loop");
                for (Vector3f v : verts = new Vector3f[]{t.get1(), t.get2(), t.get3()}) {
                    switch (this.format) {
                        default: 
                    }
                    this.writeLn("  vertex " + this.formatFloat(v.x) + " " + this.formatFloat(v.y) + " " + this.formatFloat(v.z));
                }
                switch (this.format) {
                    default: 
                }
                this.writeLn(" endloop");
                this.writeLn("endfacet");
            }
        }
    }

    private void writeLn(String s) {
        this.export.append(s + "\n");
    }

    private String formatFloat(float f) {
        return String.format(Locale.ENGLISH, "%.4f", Float.valueOf(f));
    }

    public static enum Format {
        ASCII,
        BINARY;

    }

    private class StrokePipeTriangularization {
        private Vector3f[] vertices;
        private int[] indices = new int[]{0, 1, 2};
        private List<Vector3f> strokePoints = new ArrayList<Vector3f>();
        private List<Float> strokePressureValues = new ArrayList<Float>();
        private int subdivisionAlongAxis = 6;
        private float baseExtend;
        private static final float StrokeThicknessToBaseExtendFactor = 0.002f;
        private static final float minCross = 0.01f;
        private static final float maximumPressureFactor = 6.0f;

        public StrokePipeTriangularization(Stroke3D stroke, int subdivisionAxis, float thicknessFactor) {
            StrokeInk strokeInk = stroke.getInk();
            List<Stroke3DPoint> points = stroke.getPointsInSceneCoordinates();
            this.subdivisionAlongAxis = subdivisionAxis;
            for (Stroke3DPoint p : points) {
                this.strokePressureValues.add(Float.valueOf(p.pressure.getNormalizedValue()));
                this.strokePoints.add(p.position);
            }
            this.baseExtend = strokeInk.getThickness() * 0.002f * thicknessFactor;
            this.vertices = new Vector3f[0];
            this.indices = new int[0];
            this.buildArrays();
        }

        public List<Triangle> getTriangles() {
            ArrayList<Triangle> tris = new ArrayList<Triangle>();
            for (int i = 0; i < this.indices.length; i += 3) {
                Triangle t = new Triangle(this.vertices[this.indices[i]], this.vertices[this.indices[i + 1]], this.vertices[this.indices[i + 2]]);
                t.calculateNormal();
                tris.add(t);
            }
            return tris;
        }

        private void buildArrays() {
            int pointsToAdd = this.strokePoints.size();
            int numTrianglesPerStrokePoint = this.subdivisionAlongAxis * 2;
            int numIndicesPerStrokePoint = numTrianglesPerStrokePoint * 3;
            int numVerticesPerStrokePoint = this.subdivisionAlongAxis;
            int indicesToAdd = numIndicesPerStrokePoint * (pointsToAdd - 1) + this.subdivisionAlongAxis * 3 * 2;
            int verticesToAdd = numVerticesPerStrokePoint * pointsToAdd + 2;
            int indicesEndCounter = indicesToAdd - 1;
            int vertexEndCounter = verticesToAdd - 1;
            int[] newIndices = new int[this.indices.length + indicesToAdd];
            System.arraycopy(this.indices, 0, newIndices, 0, this.indices.length);
            this.indices = newIndices;
            Vector3f[] newVertices = new Vector3f[this.vertices.length + verticesToAdd];
            System.arraycopy(this.vertices, 0, newVertices, 0, this.vertices.length);
            this.vertices = newVertices;
            Vector3f poleVector1 = Vector3f.UNIT_X.clone();
            Vector3f poleVector2 = Vector3f.UNIT_Y.clone();
            for (int s = -1; s < this.strokePoints.size(); ++s) {
                int v;
                List<Vector3f> verticesInPlane;
                if (s < 0) continue;
                if (s == 0) {
                    Vector3f p;
                    verticesInPlane = this.calculateVertices(poleVector1, poleVector2, this.subdivisionAlongAxis, null, this.strokePoints.get(s), this.strokePoints.get(s + 1), this.strokePressureValues.get(s).floatValue());
                    for (int v2 = 0; v2 < verticesInPlane.size(); ++v2) {
                        this.vertices[s * numVerticesPerStrokePoint + v2] = verticesInPlane.get(v2);
                    }
                    this.vertices[vertexEndCounter] = p = this.strokePoints.get(s);
                    for (v = 0; v < verticesInPlane.size(); ++v) {
                        this.indices[indicesEndCounter--] = vertexEndCounter;
                        this.indices[indicesEndCounter--] = s * numVerticesPerStrokePoint + v;
                        this.indices[indicesEndCounter--] = s * numVerticesPerStrokePoint + (v + 1) % this.subdivisionAlongAxis;
                    }
                    --vertexEndCounter;
                    continue;
                }
                if (s == this.strokePoints.size() - 1) {
                    Vector3f p;
                    verticesInPlane = this.calculateVertices(poleVector1, poleVector2, this.subdivisionAlongAxis, this.strokePoints.get(s - 1), this.strokePoints.get(s), null, this.strokePressureValues.get(s).floatValue());
                    for (int v3 = 0; v3 < verticesInPlane.size(); ++v3) {
                        this.vertices[s * numVerticesPerStrokePoint + v3] = verticesInPlane.get(v3);
                    }
                    this.assignIndices(numIndicesPerStrokePoint, s);
                    this.vertices[vertexEndCounter] = p = this.strokePoints.get(s);
                    for (v = 0; v < verticesInPlane.size(); ++v) {
                        this.indices[indicesEndCounter--] = vertexEndCounter;
                        this.indices[indicesEndCounter--] = s * numVerticesPerStrokePoint + (v + 1) % this.subdivisionAlongAxis;
                        this.indices[indicesEndCounter--] = s * numVerticesPerStrokePoint + v;
                    }
                    --vertexEndCounter;
                    continue;
                }
                verticesInPlane = this.calculateVertices(poleVector1, poleVector2, this.subdivisionAlongAxis, this.strokePoints.get(s - 1), this.strokePoints.get(s), this.strokePoints.get(s + 1), this.strokePressureValues.get(s).floatValue());
                for (int v4 = 0; v4 < verticesInPlane.size(); ++v4) {
                    this.vertices[s * numVerticesPerStrokePoint + v4] = verticesInPlane.get(v4);
                }
                this.assignIndices(numIndicesPerStrokePoint, s);
            }
        }

        private void assignIndices(int numIndicesPerStrokePoint, int s) {
            for (int quadsection = 0; quadsection < this.subdivisionAlongAxis; ++quadsection) {
                int a = s * this.subdivisionAlongAxis + quadsection;
                int b = a + 1;
                if (quadsection == this.subdivisionAlongAxis - 1) {
                    b = a - quadsection;
                }
                int x = a - this.subdivisionAlongAxis;
                int y = b - this.subdivisionAlongAxis;
                int firstIndexOfQuad = numIndicesPerStrokePoint * (s - 1) + quadsection * 3 * 2;
                this.indices[firstIndexOfQuad++] = a;
                this.indices[firstIndexOfQuad++] = x;
                this.indices[firstIndexOfQuad++] = b;
                this.indices[firstIndexOfQuad++] = b;
                this.indices[firstIndexOfQuad++] = x;
                this.indices[firstIndexOfQuad++] = y;
            }
        }

        private List<Vector3f> calculateVertices(Vector3f poleVector1, Vector3f poleVector2, int numVerticesInOnePlane, Vector3f a, Vector3f b, Vector3f c, float normalizedStrokePressure) {
            ArrayList<Vector3f> returnvalue = new ArrayList<Vector3f>(numVerticesInOnePlane);
            Vector3f planeNormal = Vector3f.UNIT_XYZ.clone();
            Vector3f planeCenter = b;
            if (a == null && b != null && c != null) {
                planeNormal = c.subtract(b).normalize();
            } else if (a != null && b != null && c == null) {
                planeNormal = b.subtract(a).normalize();
            } else if (a != null && b != null && c != null) {
                planeNormal = c.subtract(a).normalize();
            }
            Vector3f pole = poleVector1;
            if (normalizedStrokePressure < 0.0f) {
                normalizedStrokePressure = 0.0f;
            }
            float extend = Interpolation.linearTransform(this.baseExtend, 6.0f * this.baseExtend, normalizedStrokePressure);
            Vector3f normalizedPlaneVector = pole.subtract(pole.project(planeNormal)).normalize();
            Quaternion rotation = new Quaternion();
            float sectionAngle = (float)Math.PI * 2 / (float)numVerticesInOnePlane;
            for (int i = 0; i < numVerticesInOnePlane; ++i) {
                float angle = (float)i * sectionAngle;
                Vector3f v = rotation.fromAngleAxis(angle, planeNormal).mult(normalizedPlaneVector).mult(extend);
                returnvalue.add(planeCenter.add(v));
            }
            return returnvalue;
        }
    }
}

