/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.files;

import com.hybridlab.hyve3d.core.Stroke3D;
import com.hybridlab.hyve3d.core.Stroke3DPoint;
import com.hybridlab.hyve3d.core.StrokeId;
import com.hybridlab.hyve3d.core.StrokeInk;
import com.hybridlab.hyve3d.data.domainobjects.Stroke;
import com.hybridlab.hyve3d.data.valueobjects.Ink;
import com.hybridlab.hyve3d.data.valueobjects.StrokePoint;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import java.util.HashSet;
import java.util.Set;

public class StrokeConverter {
    public static Set<Stroke3D> convertStrokes(Set<Stroke> allSessionStrokes) {
        HashSet<Stroke3D> s3ds = new HashSet<Stroke3D>();
        for (Stroke s : allSessionStrokes) {
            s3ds.add(StrokeConverter.convert(s));
        }
        return s3ds;
    }

    public static Stroke3D convert(Stroke s) {
        StrokeInk ink = StrokeConverter.InkToStrokeInk(new Ink(s.getColor(), s.getStyle(), Float.valueOf(s.getBaseThickness())));
        Stroke3D s3d = new Stroke3D(ink);
        s3d.setStrokeId(new StrokeId(s.getId()));
        s3d.setIsSelectable(s.getIsSelectable());
        for (Stroke3DPoint p : s.getPointsInSceneCoordinates()) {
            s3d.addPoint(p);
        }
        return s3d;
    }

    public static Stroke convert(Stroke3D s3d) {
        Transformation trf = new Transformation();
        Stroke s = new Stroke(s3d.getId(), StrokeConverter.StrokeInkToInk(s3d.getInk()), trf);
        s.setIsSelectable(s3d.isSelectable());
        for (int i = 0; i < s3d.getNumberOfPoints(); ++i) {
            Stroke3DPoint p = s3d.getStrokePoint(i);
            s.addStrokePoint(StrokeConverter.convert(p));
        }
        return s;
    }

    private static StrokePoint convert(Stroke3DPoint p) {
        StrokePoint sp = new StrokePoint(p.position, p.pressure);
        return sp;
    }

    public static StrokeInk InkToStrokeInk(Ink ink) {
        StrokeInk si = new StrokeInk();
        switch (ink.getStyle()) {
            case FACE: {
                si.setStyle(StrokeInk.StrokeStyle.RectangleStrokeTube);
                break;
            }
            default: {
                si.setStyle(StrokeInk.StrokeStyle.Line);
            }
        }
        si.setColor(ink.getColor());
        si.setThickness(ink.getBaseThickness());
        si.setPressureFactor(ink.getPressureFactor());
        return si;
    }

    public static Ink StrokeInkToInk(StrokeInk strokeInk) {
        Ink.Style s = Ink.Style.LINE;
        switch (strokeInk.getStyle()) {
            default: {
                s = Ink.Style.LINE;
                break;
            }
            case RectangleStrokeTube: 
            case TriangleStrokeTube: {
                s = Ink.Style.FACE;
            }
        }
        return new Ink(strokeInk.getColor(), s, Float.valueOf(strokeInk.getThickness()), Float.valueOf(strokeInk.getPressureFactor()));
    }
}

