/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.geometry;

import com.jme3.asset.AssetManager;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Cylinder;

public class Jme3TabletVisualization {
    float tabletHeightInPortraitMode = 11.0f;
    float tabletWidthInPortraitMode = 6.0f;
    float tabletThickness = 0.5f;
    float tabletScreenPortraitWidth = 5.1f;
    float tabletScreenPortraitHeight = 7.6f;
    float tabletScale = 1.0f;
    AssetManager assetManager;
    Node rootNode = new Node("device rootnode");
    ColorRGBA housingColor = new ColorRGBA(0.5f, 0.5f, 0.5f, 0.8f);
    ColorRGBA screenColor = new ColorRGBA(0.6f, 0.6f, 0.8f, 0.4f);

    public Jme3TabletVisualization(AssetManager assetManager, float tabletHeightInPortraitMode, float tabletWidthInPortraitMode, float tabletScreenPortraitWidth, float tabletScreenPortraitHeight, float tabletThickness, float tabletScale) {
        this.assetManager = assetManager;
        this.tabletHeightInPortraitMode = tabletHeightInPortraitMode;
        this.tabletWidthInPortraitMode = tabletWidthInPortraitMode;
        this.tabletScreenPortraitWidth = tabletScreenPortraitWidth;
        this.tabletScreenPortraitHeight = tabletScreenPortraitHeight;
        this.tabletThickness = tabletThickness;
        this.tabletScale = tabletScale;
        this.build();
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    private void build() {
        this.rootNode.setLocalScale(this.tabletScale);
        Vector3f housingExtend = new Vector3f(this.tabletWidthInPortraitMode * 0.5f, this.tabletThickness * 0.5f, this.tabletHeightInPortraitMode * 0.5f);
        Vector3f screenExtend = new Vector3f(this.tabletScreenPortraitWidth * 0.5f, 0.1f * this.tabletThickness * 0.5f, this.tabletScreenPortraitHeight * 0.5f);
        Geometry housing = new Geometry("device housing", (Mesh)new Box(housingExtend.x, housingExtend.y, housingExtend.z));
        Geometry screen = new Geometry("device screen", (Mesh)new Box(screenExtend.x, screenExtend.y, screenExtend.z));
        screen.setLocalTranslation(0.0f, 0.0f, 0.0f);
        housing.setLocalTranslation(0.0f, -this.tabletThickness, 0.0f);
        Geometry button = new Geometry("button", (Mesh)new Cylinder(2, 12, 0.5f, 0.1f, true));
        button.setLocalRotation(new Quaternion(new float[]{1.5707964f, 0.0f, 0.0f}));
        button.setLocalTranslation(0.0f, 0.0f, 0.5f * this.tabletScreenPortraitHeight + 0.25f * (this.tabletHeightInPortraitMode - this.tabletScreenPortraitHeight));
        this.rootNode.attachChild((Spatial)button);
        this.rootNode.attachChild((Spatial)screen);
        this.rootNode.attachChild((Spatial)housing);
        this.rootNode.setLocalTranslation(0.0f, 0.0f, -0.6f * this.tabletThickness);
        Material matScreen = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        matScreen.setColor("Color", this.screenColor);
        screen.setMaterial(matScreen);
        Material matHousing = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        matHousing.setColor("Diffuse", this.housingColor);
        matHousing.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        housing.setMaterial(matHousing);
        housing.setQueueBucket(RenderQueue.Bucket.Transparent);
        button.setMaterial(matScreen);
        AmbientLight al = new AmbientLight();
        al.setColor(ColorRGBA.White.mult(0.3f));
        this.rootNode.addLight((Light)al);
        DirectionalLight dl = new DirectionalLight();
        dl.setColor(ColorRGBA.White);
        dl.setDirection(new Vector3f(0.0f, -1.0f, 0.0f).normalizeLocal());
    }
}

