/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.geometry;

import com.hybridlab.utils.Interpolation;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Line;

public class SceneCoordinateSystem
extends Node {
    Material matXPos;
    Material matXNeg;
    Material matYPos;
    Material matYNeg;
    Material matZPos;
    Material matZneg;
    Material matGrid;

    public SceneCoordinateSystem(AssetManager assetManager) {
        Vector3f origin = new Vector3f(0.0f, 0.0f, 0.0f);
        float PI = (float)Math.PI;
        float PI_HALF = 1.5707964f;
        float axisLength = 10.0f;
        float gridLineLength = 100.0f;
        float gridLineDistance = 10.0f;
        this.matXPos = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.matXNeg = this.matXPos.clone();
        this.matYPos = this.matXPos.clone();
        this.matYNeg = this.matXPos.clone();
        this.matZPos = this.matXPos.clone();
        this.matZneg = this.matXPos.clone();
        this.matGrid = this.matXPos.clone();
        this.matGrid.setColor("Color", new ColorRGBA(0.3f, 0.3f, 0.3f, 0.5f));
        this.matXPos.setColor("Color", ColorRGBA.Red);
        this.matXNeg.setColor("Color", ColorRGBA.Orange);
        this.matYPos.setColor("Color", ColorRGBA.Green);
        this.matYNeg.setColor("Color", new ColorRGBA(0.0f, 1.0f, 0.5f, 0.0f));
        this.matZPos.setColor("Color", ColorRGBA.Blue);
        this.matZneg.setColor("Color", new ColorRGBA(0.0f, 0.5f, 1.0f, 0.0f));
        Line axis = new Line(origin, new Vector3f(axisLength, 0.0f, 0.0f));
        axis.setLineWidth(3.5f);
        Line gridline = new Line(new Vector3f(gridLineLength * 0.5f, 0.0f, 0.0f), new Vector3f(-gridLineLength * 0.5f, 0.0f, 0.0f));
        gridline.setLineWidth(1.75f);
        Geometry geoXPos = new Geometry("axis", (Mesh)axis);
        geoXPos.setMaterial(this.matXPos);
        this.attachChild((Spatial)geoXPos);
        Geometry geoXNeg = geoXPos.clone();
        geoXNeg.setMaterial(this.matXNeg);
        geoXNeg.rotate(0.0f, (float)Math.PI, 0.0f);
        this.attachChild((Spatial)geoXNeg);
        Geometry geoYPos = geoXPos.clone();
        geoYPos.setMaterial(this.matYPos);
        geoYPos.rotate(0.0f, 0.0f, 1.5707964f);
        this.attachChild((Spatial)geoYPos);
        Geometry geoZPos = geoXPos.clone();
        geoZPos.setMaterial(this.matZPos);
        geoZPos.rotate(0.0f, -1.5707964f, 0.0f);
        this.attachChild((Spatial)geoZPos);
        Geometry geoZNeg = geoXPos.clone();
        geoZNeg.setMaterial(this.matZneg);
        geoZNeg.rotate(0.0f, 1.5707964f, 0.0f);
        this.attachChild((Spatial)geoZNeg);
        Geometry pole1 = geoYPos.clone();
        pole1.setMaterial(this.matYPos);
        pole1.setLocalTranslation(new Vector3f(axisLength, 0.0f, axisLength));
        this.attachChild((Spatial)pole1);
        Geometry pole2 = geoYPos.clone();
        pole2.setMaterial(this.matYNeg);
        pole2.setLocalTranslation(new Vector3f(-axisLength, 0.0f, axisLength));
        this.attachChild((Spatial)pole2);
        Geometry pole3 = geoYPos.clone();
        pole3.setMaterial(this.matZPos);
        pole3.setLocalTranslation(new Vector3f(axisLength, 0.0f, -axisLength));
        this.attachChild((Spatial)pole3);
        Geometry pole4 = geoYPos.clone();
        pole4.setMaterial(this.matYNeg);
        pole4.setLocalTranslation(new Vector3f(-axisLength, 0.0f, -axisLength));
        this.attachChild((Spatial)pole4);
        Geometry gridPrototype = new Geometry("gridpart", (Mesh)gridline);
        gridPrototype.setMaterial(this.matGrid);
        float[] angles = new float[]{0.0f, 1.5707964f};
        float[] sides = new float[]{1.0f, -1.0f};
        for (float a : angles) {
            Node gridlineGroup = new Node("gridlines " + String.valueOf(a));
            for (float s : sides) {
                float pos = 0.0f;
                while ((double)pos < (double)gridLineLength * 0.5) {
                    Geometry gridPart = gridPrototype.clone();
                    float z = Interpolation.inttrf((pos += gridLineDistance) * s, 0.0f, gridLineLength * 0.5f, 0.0f, gridLineLength * 0.5f);
                    gridPart.setLocalTranslation(0.0f, 0.0f, z);
                    gridlineGroup.attachChild((Spatial)gridPart);
                }
            }
            gridlineGroup.rotate(0.0f, a, 0.0f);
            this.attachChild((Spatial)gridlineGroup);
        }
    }
}

