/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.hyve;

import com.hybridlab.hyve3d.data.Session;
import com.hybridlab.hyve3d.data.synch.CleverSessionSynchConnection;
import com.hybridlab.hyve3d.data.synch.SynchronizationProgressTracer;
import com.hybridlab.hyve3d.hyve.HyveApplication;
import com.hybridlab.hyve3d.hyve.HyveNetworking;
import com.hybridlab.hyve3d.network.discovery.NetworkServiceManager;
import com.hybridlab.hyve3d.network.interconnection.HubNode;
import com.hybridlab.hyve3d.network.interconnection.HubNodeHost;
import com.hybridlab.hyve3d.network.interconnection.InterconnectivityDataModel;
import com.hybridlab.hyve3d.network.interconnection.SessionRepository;
import com.hybridlab.hyve3d.network.interconnection.implementations.SessionSynchronizer;
import com.hybridlab.hyve3d.network.interconnection.implementations.SpiderMonkeyHubNodeHost;
import com.hybridlab.hyve3d.network.interconnection.implementations.adressing.InternetReachableHubNodeAdress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.UUID;

public class HubNodeNetworkingController
implements HyveNetworking {
    private HubNode node;
    private SessionRepository sessionRepo;
    private NetworkServiceManager networkServiceManager;
    private SynchronizationProgressTracer tracer = new SynchronizationProgressTracer.NoActionProgressTracer();
    private HubNodeHost hnh;

    @Override
    public boolean createHost(int port, HyveNetworking.HostingEstablishListener hostingListener) {
        try {
            this.hnh = new SpiderMonkeyHubNodeHost(this.node, port, this.tracer);
            this.node.setHost(this.hnh);
            this.hnh.start();
        }
        catch (Exception e) {
            hostingListener.onHostCreationFailed(e);
        }
        try {
            this.networkServiceManager.registerService("interconnection_hubnode_host", port);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            hostingListener.onHostCreationFailed(e);
            return false;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            hostingListener.onHostCreationFailed(e);
            return false;
        }
        catch (SocketException e) {
            e.printStackTrace();
            hostingListener.onHostCreationFailed(e);
            return false;
        }
        hostingListener.onHostCreated(this.hnh);
        return true;
    }

    @Override
    public void closeHost(HyveNetworking.HostingEstablishListener hostingListener) {
        this.networkServiceManager.unRegisterService("interconnection_hubnode_host", this.hnh.getPort());
        this.node.setHost(null);
        this.hnh.stop();
        hostingListener.onHostShutdown();
    }

    public HubNodeNetworkingController(HubNode n, SessionRepository sessionRepo, NetworkServiceManager networkServiceManager) {
        this.node = n;
        this.networkServiceManager = networkServiceManager;
        this.sessionRepo = sessionRepo;
    }

    public HubNodeNetworkingController(HubNode n, SessionRepository sessionRepo, NetworkServiceManager networkServiceManager, SynchronizationProgressTracer tracer) {
        this(n, sessionRepo, networkServiceManager);
        this.tracer = tracer;
    }

    @Override
    public void disconnectFromHubNode(HyveNetworking.ConnectionEstablishListener l) {
        this.node.disConnect(l);
    }

    @Override
    public void asynchConnectToHubNode(String host, int port, HyveNetworking.ConnectionEstablishListener l) {
        InternetReachableHubNodeAdress address = new InternetReachableHubNodeAdress(host, port);
        try {
            this.node.connectTo(address, this.tracer, l);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public HubNode getHubNode() {
        return this.node;
    }

    @Override
    public InterconnectivityDataModel getInterConnectivityDataModel() {
        return this.node.getInterConnectivityDataModel();
    }

    @Override
    public void shareSession(UUID sessionId, boolean mustBeConnected) {
        HubNode node = this.getHubNode();
        if (node.isConnectedToHub() || !mustBeConnected) {
            Session session = this.sessionRepo.getSession(sessionId);
            CleverSessionSynchConnection synchConn = new CleverSessionSynchConnection(session.getInfo());
            SessionSynchronizer synch = new SessionSynchronizer(session, synchConn);
            synchConn.connectToEndPoint(node);
        } else {
            HyveApplication.showWarmingMessageInUI("Session sharing is not possible because Hubnode is not connected !");
        }
    }

    @Override
    public void synchWithRemoteSession(UUID selectedSessionId) throws Exception {
        if (selectedSessionId == null) {
            HyveApplication.showWarmingMessageInUI("no Session selected! ");
            return;
        }
        HubNode node = this.getHubNode();
        if (node.isConnectedToHub()) {
            try {
                Session session = this.sessionRepo.createNewSession(selectedSessionId);
                session.setFollowing();
                CleverSessionSynchConnection synchConn = new CleverSessionSynchConnection(session.getInfo());
                SessionSynchronizer synch = new SessionSynchronizer(session, synchConn);
                synchConn.connectToEndPoint(node);
            }
            catch (SessionRepository.SessionAlreadyInRepositoryException e) {
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
        } else {
            throw new Exception("Session sharing is not possible because Hubnode is not connected !");
        }
    }
}

