/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.hyve;

import com.hybridlab.hyve3d.core.Transformable;
import com.hybridlab.hyve3d.core.animation.Animation;
import com.hybridlab.hyve3d.core.animation.AnimationTrigger;
import com.hybridlab.hyve3d.core.animation.Animator;
import com.hybridlab.hyve3d.core.animation.CircularTransformableAnimation;
import com.hybridlab.hyve3d.core.animation.SimpleAnimation;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.hyve.ParallaxEffectParameters;
import com.hybridlab.utils.Interpolation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class ParallaxEffect
implements AnimationTrigger.TriggerListener,
Animator {
    private UUID id;
    private Object requestor;
    private ParallaxEffectParameters parameters;
    private AnimationTrigger animationtrigger;
    private boolean running = false;
    private Transformable transformable;
    private Transformation initialTransformableTransformation;
    private SimpleAnimation animation;
    private Map<String, Animation> animations = new HashMap<String, Animation>();

    public String toString() {
        return "ParallaxEffect [parameters=" + this.parameters + ", id=" + this.id + ", requestor=" + this.requestor + ", animationtrigger=" + this.animationtrigger + ", running=" + this.running + ", transformable=" + this.transformable + ", animation=" + this.animation + "]";
    }

    public ParallaxEffect(UUID id, ParallaxEffectParameters p, Object requestor) {
        this.parameters = p;
        this.requestor = requestor;
        this.id = id;
    }

    public UUID getId() {
        return this.id;
    }

    public Object getRequestor() {
        return this.requestor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.animationtrigger.removeTriggerListener(this);
        if (this.animation != null) {
            this.animation.stop();
        }
        Map<String, Animation> map = this.animations;
        synchronized (map) {
            for (Animation a : this.animations.values()) {
                a.cancel();
            }
        }
    }

    public void cancel() {
        if (this.animation != null) {
            this.animation.stop();
            CancelAnimation ani = new CancelAnimation();
            ani.registerAnimationFinishedCallback(new Animation.FinishedCallback(){

                @Override
                public void onFinished(Animation animation) {
                    ParallaxEffect.this.animationtrigger.removeTriggerListener(ParallaxEffect.this);
                }
            });
            this.playAnimation("cancel", ani);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdate(float tpf) {
        Map<String, Animation> map = this.animations;
        synchronized (map) {
            for (Animation a : this.animations.values()) {
                a.update(tpf);
            }
        }
        if (this.animation != null && this.animation.isRunning() && !this.animation.isFinished()) {
            this.animation.update(tpf);
        }
    }

    public void startWithTriggerAndTransformable(AnimationTrigger animationtrigger, Transformable cameraRig) {
        if (!this.running) {
            this.running = true;
            this.animationtrigger = animationtrigger;
            this.transformable = cameraRig;
            this.initialTransformableTransformation = this.transformable.getTransformation().copy();
            CircularTransformableAnimation ani = new CircularTransformableAnimation(this.transformable);
            ani.setCenter(this.parameters.getCenter());
            ani.setDegreesPerSecond(this.parameters.getDegreesPerSecond());
            ani.setCirclePartSizeInDegrees(this.parameters.getCirclePartSizeInDegrees());
            ani.setCirclePlaneNormal(this.parameters.getCirclePlaneNormal());
            this.animation = ani;
            this.animation.start();
            this.animationtrigger.addTriggerListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playAnimation(String channel, Animation animation) {
        animation.prepare();
        Map<String, Animation> map = this.animations;
        synchronized (map) {
            Animation previous = this.animations.remove(channel);
            if (previous != null) {
                previous.cancel();
            }
            this.animations.put(channel, animation);
        }
        this.animationtrigger.addTriggerListener(this);
    }

    private class CancelAnimation
    implements Animation {
        private Transformation begin;
        private Transformation end;
        private float durationInSecondsSoFar = 0.0f;
        private float durationInSeconds = 0.5f;
        private boolean running = false;
        private Set<Animation.FinishedCallback> endcallbacks = new HashSet<Animation.FinishedCallback>();

        private CancelAnimation() {
        }

        @Override
        public long getDurationInMilliseconds() {
            return (long)(this.durationInSeconds * 1000.0f);
        }

        @Override
        public void prepare() {
            this.begin = ParallaxEffect.this.transformable.getTransformation().copy();
            this.end = ParallaxEffect.this.initialTransformableTransformation;
            this.durationInSeconds = 0.001f * (float)ParallaxEffect.this.parameters.getCancelDurationInMilliseconds();
            this.running = true;
        }

        @Override
        public void step(float t) {
            Transformation trf = Transformation.interpolate(this.begin, this.end, t);
            ParallaxEffect.this.transformable.setTransformation(trf);
        }

        @Override
        public void cleanup() {
            this.running = false;
            if (ParallaxEffect.this.animationtrigger != null) {
                ParallaxEffect.this.animationtrigger.removeTriggerListener(ParallaxEffect.this);
            }
            this.finish();
        }

        private void finish() {
            for (Animation.FinishedCallback cb : this.endcallbacks) {
                cb.onFinished(this);
            }
            this.endcallbacks.clear();
        }

        @Override
        public void cancel() {
            this.cleanup();
        }

        @Override
        public void update(float tpf) {
            if (this.running) {
                if (this.durationInSecondsSoFar < this.durationInSeconds) {
                    float t = Interpolation.inttrf(this.durationInSecondsSoFar, 0.0f, this.durationInSeconds, 0.0f, 1.0f);
                    this.step(t);
                    this.durationInSecondsSoFar += tpf;
                } else {
                    this.step(1.0f);
                    this.running = false;
                }
            }
        }

        @Override
        public void registerAnimationFinishedCallback(Animation.FinishedCallback cb) {
            this.endcallbacks.add(cb);
        }
    }
}

