/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.hyve;

import com.hybridlab.hyve3d.config.NamedAngle;
import com.hybridlab.hyve3d.core.FrameRect;
import com.hybridlab.hyve3d.core.Satellite;
import com.hybridlab.hyve3d.data.valueobjects.Transformation;
import com.hybridlab.hyve3d.hyve.Hyve;
import com.hybridlab.hyve3d.hyve.IpadSatellite;
import com.hybridlab.hyve3d.inputdevice.InputDeviceManager;
import com.hybridlab.hyve3d.network.discovery.NetworkServiceManager;
import com.hybridlab.hyve3d.network.messages.SatelliteSessionSetupMessage;
import com.hybridlab.hyve3d.network.messages.TransformMessage;
import com.hybridlab.hyve3d.satellitecenter.SatelliteClientConfiguration;
import com.hybridlab.hyve3d.satellitecenter.SatelliteClientConfigurationSet;
import com.hybridlab.hyve3d.satellitecenter.SatelliteServer;
import com.hybridlab.hyve3d.satellitecenter.SatelliteSession;
import com.hybridlab.hyve3d.satellitecenter.SatelliteSessionObserver;
import com.jme3.math.ColorRGBA;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class SatelliteCenter
implements SatelliteSessionObserver {
    private static final Logger logger = Logger.getLogger(SatelliteCenter.class.getSimpleName());
    private SatelliteServer satelliteServer;
    private NetworkServiceManager networkServiceManager;
    private List<SatelliteSession> satsessions = new ArrayList<SatelliteSession>();
    private Map<SatelliteSession, Satellite> sessionSatelliteMap = new HashMap<SatelliteSession, Satellite>();
    private Map<String, Satellite> satellites = new HashMap<String, Satellite>();
    private List<String> satelliteIds = new ArrayList<String>();
    private Set<SatelliteListeners> listeners = new HashSet<SatelliteListeners>();
    private SatelliteClientConfigurationSet satelliteConfigurations;
    private InputDeviceManager inputDeviceManager;
    private TransformMessage.Source rotationSource = TransformMessage.Source.HYDRA;
    private NamedAngle hydraAttachmentAngle;
    private Hyve localhyve;

    public SatelliteCenter(NetworkServiceManager networkServiceManager, InputDeviceManager inputDeviceManager, SatelliteClientConfigurationSet satelliteClientConfigurationSet, NamedAngle hydraAttachmentAngle, Hyve localhyve) {
        this.networkServiceManager = networkServiceManager;
        this.satelliteServer = new SatelliteServer(this.networkServiceManager);
        this.inputDeviceManager = inputDeviceManager;
        this.satelliteConfigurations = satelliteClientConfigurationSet;
        this.hydraAttachmentAngle = hydraAttachmentAngle;
        this.localhyve = localhyve;
    }

    public void start() {
        this.satelliteServer.registerSessionObserver(this);
        this.satelliteServer.startListenForConnectionsAndServe();
    }

    public void stop() {
        this.satelliteServer.shutdown();
    }

    public void registerListener(SatelliteListeners l) {
        this.listeners.add(l);
    }

    @Override
    public void onNewSatelliteSession(SatelliteSession session) {
        this.satsessions.add(session);
    }

    @Override
    public void onSatelliteSessionClosed(SatelliteSession session) {
        Satellite sat = this.sessionSatelliteMap.remove(session);
        sat.onSessionClosed(session);
        this.satsessions.remove(session);
    }

    @Override
    public void onSessionSetup(SatelliteSession session, SatelliteSessionSetupMessage setupMessage) {
        logger.info(setupMessage.toString());
        try {
            String satelliteId = setupMessage.getSatelliteDeviceId();
            SatelliteClientConfiguration satConfig = this.loadSatelliteConfig(satelliteId);
            Satellite sat = this.getSatelliteOrCreate(satelliteId, setupMessage, satConfig, session);
            this.sessionSatelliteMap.put(session, sat);
            sat.onSessionOpened(session);
        }
        catch (SatelliteSessionSetupMessage.NoSatelliteDeviceIdException e) {
            logger.severe(e.getLocalizedMessage());
        }
    }

    private Satellite getSatelliteOrCreate(String satelliteId, SatelliteSessionSetupMessage setupMessage, SatelliteClientConfiguration satConfig, SatelliteSession session) {
        Satellite sat = this.satellites.get(satelliteId);
        boolean created = false;
        if (sat == null) {
            created = true;
            this.satelliteIds.add(satelliteId);
            String version = setupMessage.getVersion();
            sat = new IpadSatellite(satelliteId, this, satConfig, version);
            sat.setRotationSource(this.rotationSource);
            this.satellites.put(satelliteId, sat);
        }
        if (sat.getSession() != null && sat.getSession() != session) {
            sat.onSessionClosed(sat.getSession());
        }
        String satelliteName = setupMessage.getDeviceName();
        sat.setName(satelliteName);
        FrameRect r = new FrameRect(1.3333334f);
        r.multLocal(2.0f);
        sat.setFrame(r);
        try {
            logger.info(setupMessage.getDesiredFrameRect().toString());
        }
        catch (SatelliteSessionSetupMessage.NoFrameRectException e) {
            e.printStackTrace();
        }
        ColorRGBA satFrameColor = satConfig.getRegularFrameColor();
        sat.setRegularFrameColor(satFrameColor);
        if (setupMessage.hasTrackingInfo()) {
            sat.setTrackingInfos(setupMessage.getIsTrackingEnabled(), setupMessage.getTrackingIdentifier());
        }
        if (created) {
            for (SatelliteListeners l : this.listeners) {
                l.satelliteCreated(sat);
            }
        }
        return sat;
    }

    private SatelliteClientConfiguration loadSatelliteConfig(String satelliteId) {
        SatelliteClientConfiguration satelliteConfig = this.satelliteConfigurations.get(satelliteId);
        if (null == satelliteConfig) {
            satelliteConfig = new SatelliteClientConfiguration();
            satelliteConfig.setSatelliteId(satelliteId);
            this.satelliteConfigurations.put(satelliteId, satelliteConfig);
        }
        return satelliteConfig;
    }

    public int getSatelliteIndex(String satid) {
        return this.satelliteIds.indexOf(satid);
    }

    public void setRotationSource(TransformMessage.Source s) {
        this.rotationSource = s;
        for (Satellite sat : this.satellites.values()) {
            sat.setRotationSource(s);
        }
    }

    public Transformation getLocalSpaceTransformation() {
        return this.localhyve.getLocalSpace().getTransformation();
    }

    public static interface SatelliteListeners {
        public void satelliteCreated(Satellite var1);
    }
}

