/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.hyve;

import com.hybridlab.hyve3d.core.Stroke2D;
import com.hybridlab.hyve3d.core.Stroke3DPoint;
import com.hybridlab.hyve3d.core.StrokeId;
import com.hybridlab.hyve3d.core.StrokeInk;
import com.hybridlab.hyve3d.core.StylusPressure;
import com.hybridlab.hyve3d.data.Session;
import com.hybridlab.hyve3d.data.domainobjects.DrawingArea;
import com.hybridlab.hyve3d.data.domainobjects.Stroke;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class StrokeProjector {
    private DrawingArea drawingArea;
    private Session session;
    private List<Stroke2D> lastProjected = new ArrayList<Stroke2D>();
    private static final Quaternion rotationBetweenFrameRectAndDrawingArea = new Quaternion(new float[]{0.0f, 0.0f, 1.5707964f});

    public static List<Stroke2D> ensureStrokesConsistOfMaximumAmountOfPoints(List<Stroke2D> strokesWithAnyAmountOfPoints, int maxAmountOfPointsInStroke) {
        ArrayList<Stroke2D> strokesWithCertainMaxiumumAmountOfPoints = new ArrayList<Stroke2D>();
        for (Stroke2D s : strokesWithAnyAmountOfPoints) {
            if (s.getPoints().size() <= maxAmountOfPointsInStroke) {
                strokesWithCertainMaxiumumAmountOfPoints.add(s);
                continue;
            }
            Set<Stroke2D> splitStrokes = StrokeProjector.splitStrokeEnsuringMaximumAmountOfPoints(s, maxAmountOfPointsInStroke);
            strokesWithCertainMaxiumumAmountOfPoints.addAll(splitStrokes);
        }
        return strokesWithCertainMaxiumumAmountOfPoints;
    }

    private static Set<Stroke2D> splitStrokeEnsuringMaximumAmountOfPoints(Stroke2D s, int maxAmountOfPointsInStroke) {
        HashSet<Stroke2D> splits = new HashSet<Stroke2D>();
        int n = s.getPoints().size();
        int i = 0;
        List<Vector2f> points = s.getPoints();
        List<StylusPressure> pressures = s.getPressures();
        while (i < n) {
            int a = Math.max(0, i - 1);
            int b = Math.min(i + maxAmountOfPointsInStroke + 1, points.size());
            List<Vector2f> subpoints = points.subList(a, b);
            List<StylusPressure> subpressures = pressures;
            Stroke2D split = Stroke2D.createSimilarButDifferentPoints(s, subpoints, subpressures);
            splits.add(split);
            i = b;
        }
        return splits;
    }

    public void project() {
        if (this.session == null) {
            return;
        }
        if (this.drawingArea == null) {
            return;
        }
        Set<Stroke> strokes = this.session.getAllStrokes();
        this.lastProjected = this.calculateProjectedStrokes(strokes);
    }

    public List<Stroke2D> getProjected() {
        return this.lastProjected;
    }

    public void setSession(Session s) {
        this.session = s;
        if (this.session == null) {
            this.lastProjected = new ArrayList<Stroke2D>();
        }
    }

    private List<Stroke2D> calculateProjectedStrokes(Set<Stroke> strokes) {
        ArrayList<Stroke2D> projectedStrokes = new ArrayList<Stroke2D>();
        Matrix4f transformationMatrix = new Matrix4f();
        Quaternion rotationOfProjectionPlane = this.drawingArea.getTransformation().getRotation().clone();
        Vector3f originPosition = this.drawingArea.getTransformation().getPosition().clone();
        rotationOfProjectionPlane.toRotationMatrix(transformationMatrix);
        transformationMatrix.setTranslation(originPosition);
        Matrix4f projectionMatrix = transformationMatrix.invert();
        for (Stroke s : strokes) {
            Stroke2D projectedStroke2D = new Stroke2D();
            projectedStroke2D.setInk(StrokeInk.createDefaultProjectionInk());
            projectedStroke2D.setStrokeId(new StrokeId(s.getId()));
            List<Stroke3DPoint> points3d = s.getPointsInSceneCoordinates();
            ArrayList<Vector2f> points2d = new ArrayList<Vector2f>();
            for (Stroke3DPoint p3 : points3d) {
                Vector3f p3Projected = projectionMatrix.mult(p3.position);
                Vector3f p3ProjectedInFrameRect = rotationBetweenFrameRectAndDrawingArea.mult(p3Projected);
                points2d.add(new Vector2f(-p3ProjectedInFrameRect.x, -p3ProjectedInFrameRect.y));
            }
            projectedStroke2D.addPoints(points2d);
            projectedStrokes.add(projectedStroke2D);
        }
        return projectedStrokes;
    }

    public void setDrawingArea(DrawingArea drawingArea) {
        this.drawingArea = drawingArea;
    }
}

