/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.hyve.undoredo;

import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.data.domainobjects.Selectable;
import com.hybridlab.hyve3d.hyve.undoredo.AbstractExecutableCommand;
import com.hybridlab.hyve3d.hyve.undoredo.TransformerState;
import com.jme3.math.Transform;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

@com.jme3.network.serializing.Serializable
public class DrawingAreaTransformationCommand
extends AbstractExecutableCommand
implements Serializable {
    private static final long serialVersionUID = 7964810283454181016L;
    private Map<UUID, Transform> transformationsBefore = new HashMap<UUID, Transform>();
    private Map<UUID, Transform> transformationsAfter = new HashMap<UUID, Transform>();
    private String description;
    private TransformerState transformerStateAfter;
    private TransformerState transformerStateBefore;

    public DrawingAreaTransformationCommand() {
    }

    public DrawingAreaTransformationCommand(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setAfter(Set<Selectable> selected) {
        this.transformationsAfter.clear();
        for (Selectable s : selected) {
            HyveData d = s.getData();
            UUID id = d.getId();
            Transform t = s.getTransformation();
            this.transformationsAfter.put(id, t.clone());
        }
    }

    public void setBefore(Set<Selectable> selected) {
        this.transformationsBefore.clear();
        for (Selectable s : selected) {
            HyveData d = s.getData();
            UUID id = d.getId();
            Transform t = s.getTransformation();
            this.transformationsBefore.put(id, t.clone());
        }
    }

    public Transform getAfterTransformation(UUID id) {
        return this.transformationsAfter.get(id);
    }

    public Transform getBeforeTransformation(UUID id) {
        return this.transformationsBefore.get(id);
    }

    public void setTransformerStateAfter(TransformerState transformerState) {
        this.transformerStateAfter = transformerState;
    }

    public void setTransformerStateBefore(TransformerState transformerState) {
        this.transformerStateBefore = transformerState;
    }

    public TransformerState getTrfStateAfter() {
        return this.transformerStateAfter;
    }

    public TransformerState getTrfStateBefore() {
        return this.transformerStateBefore;
    }
}

