/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.hyveclient;

import com.hybridlab.hyve3d.core.HisSphericalRendererApplication;
import com.hybridlab.hyve3d.nina.Jme3DualViewPortRenderer;
import com.hybridlab.hyve3d.rendering.spherical.ProjectionCalibrator;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;

public class HyveClientProjectionCalibrator
implements ProjectionCalibrator {
    private Jme3DualViewPortRenderer jme3DualViewPortRenderer;
    private float halfFOVangleRad;
    private float sphereViewportRadius = 1.0f;
    private float SphereCamDistance = 30.0f;
    private float SphereScale = 1.0f;
    private Set<ProjectionCalibrator.ProjectionCalibrationValueChangeListener> valueChangeListeners = new HashSet<ProjectionCalibrator.ProjectionCalibrationValueChangeListener>();
    private boolean doNothingIfEquals = true;
    private boolean connectFOVandDistance = true;

    public HyveClientProjectionCalibrator(Jme3DualViewPortRenderer jme3DualViewPortRenderer) {
        this.jme3DualViewPortRenderer = jme3DualViewPortRenderer;
    }

    void setDoNothingIfValueAlreadyEquals(boolean b) {
        this.doNothingIfEquals = b;
    }

    private void setFOVAndCorrectCameraDistanceToFitViewportRadius(float fullFovInDegrees) {
        this.setSpherecameraFieldOfViewAngleAlongYInDegrees(fullFovInDegrees, true);
    }

    private void setCameraDistanceAndCorrectFOVToFitViewportRadius(float distance) {
        System.out.println(this.getClass().getSimpleName() + ".setCameraDistanceAndCorrectFOVToFitViewportRadius(" + distance + ")");
        this.setCameraDistance(distance, true);
    }

    @Override
    public void setMode(HisSphericalRendererApplication.AppMode mode) {
        this.setDoNothingIfValueAlreadyEquals(false);
        this.setSphereScale(this.SphereScale);
        this.setViewPortRadius(this.sphereViewportRadius);
        this.setDoNothingIfValueAlreadyEquals(true);
    }

    @Override
    public void changeSpherecamViewPortRadius(float keyPressed) {
        this.setViewPortRadius(this.sphereViewportRadius + keyPressed * 0.05f);
    }

    @Override
    public void setProjectionParameters(Float sphereScale, Float sphereViewportRadius, Float sphereCamDistance, Float sphereCamFieldOfView) {
        this.setDoNothingIfValueAlreadyEquals(false);
        System.out.println("===============================================================");
        System.out.println(this.getClass().getSimpleName() + ".setProjectionParameters( ... )");
        System.out.println("== 4 Parameters:");
        System.out.println("==          sphereScale = " + sphereScale);
        this.setSphereScale(sphereScale.floatValue());
        System.out.println("== sphereViewportRadius = " + sphereViewportRadius);
        System.out.println("==    sphereCamDistance = " + sphereCamDistance);
        System.out.println("== sphereCamFieldOfView = " + sphereCamFieldOfView);
        System.out.println("== ");
        System.out.println("== controlcalculations:");
        float xFullFOVangleInDegrees = this.calculateFullFOVangleInDegrees2(sphereCamDistance.floatValue(), sphereViewportRadius.floatValue());
        float xDistanceWithFOVandRadius = this.calculateDistanceUsingDeg(sphereCamFieldOfView.floatValue(), sphereViewportRadius.floatValue());
        float xRadiusWithFOVandDistance = this.calculateRadiusUsingDeg(sphereCamFieldOfView.floatValue(), sphereCamDistance.floatValue());
        System.out.println("==    xFullFOVangleInDegrees = calculateFullFOVangleInDegrees2(sphereCamDistance: " + sphereCamDistance + ",sphereViewportRadius: " + sphereViewportRadius + ")");
        System.out.println("==      --> " + xFullFOVangleInDegrees);
        System.out.println("==    xDistanceWithFOVandRadius = calculateDistanceUsingDeg(sphereCamFieldOfView: " + sphereCamFieldOfView + ",sphereViewportRadius: " + sphereViewportRadius + ")");
        System.out.println("==      --> " + xDistanceWithFOVandRadius);
        System.out.println("==    xRadiusWithFOVandDistance = calculateRadiusUsingDeg(sphereCamFieldOfView: " + sphereCamFieldOfView + ",sphereCamDistance: " + sphereCamDistance + ")");
        System.out.println("==      --> " + xRadiusWithFOVandDistance);
        System.out.println("==      ");
        this.halfFOVangleRad = 0.5f * sphereCamFieldOfView.floatValue() * ((float)Math.PI / 180);
        System.out.println("==   this.halfFOVangleRad = " + this.halfFOVangleRad);
        System.out.println("==   setViewPortRadius(sphereViewportRadius: " + sphereViewportRadius + ")");
        System.out.println("==    // implies call of setCameraDistanceAndCorrectFOVToFitViewportRadius() ...");
        this.setViewPortRadius(sphereViewportRadius.floatValue());
        System.out.println("===============================================================");
        this.setDoNothingIfValueAlreadyEquals(true);
    }

    @Override
    public void changeSpherecamDistance(float keyPressed) {
        float d = this.getCameraDistance();
        float diff = d * 0.25f;
        this.setCameraDistance(d += keyPressed * diff, true);
    }

    @Override
    public void changeSpherecamScale(float f) {
        float s = this.jme3DualViewPortRenderer.sphereScene.getLocalScale().getY() + f * 0.05f;
        this.setSphereScale(s);
    }

    @Override
    public float getCameraDistance() {
        return this.SphereCamDistance;
    }

    @Override
    public void setCameraDistance(float distance) {
        this.setCameraDistance(distance, false);
    }

    private float calculateRadiusUsingDeg(float fullFOVangleDeg, float distance) {
        return this.calculateRadius(0.5f * fullFOVangleDeg * ((float)Math.PI / 180), distance);
    }

    private float calculateRadius(float halfFOVangleRad, float distance) {
        if (Float.isNaN(halfFOVangleRad) || Float.isNaN(distance)) {
            return 1.0f;
        }
        float radius = distance * FastMath.sin((float)halfFOVangleRad);
        if (Float.isNaN(radius)) {
            return 1.0f;
        }
        return radius;
    }

    private float calculateDistanceUsingDeg(float fullFOVangleDeg, float radius) {
        return this.calculateDistance(0.5f * fullFOVangleDeg * ((float)Math.PI / 180), radius);
    }

    private float calculateDistance(float halfFOVangleRad, float radius) {
        if (Float.isNaN(halfFOVangleRad) || Float.isNaN(radius)) {
            return 30.0f;
        }
        float distance = radius / FastMath.sin((float)halfFOVangleRad);
        if (Float.isNaN(distance)) {
            return 30.0f;
        }
        return distance;
    }

    private float calculateFullFOVangleInDegrees(float distance, float radius) {
        if (Float.isNaN(distance) || Float.isNaN(radius)) {
            return 50.0f;
        }
        float halfFOVangleRad = this.calculateHalfFOVangleInRadians(distance, radius);
        float fovdeg = 2.0f * halfFOVangleRad * 57.295776f;
        return fovdeg;
    }

    @Deprecated
    private float calculateHalfFOVangleInRadians(float distance, float radius) {
        if (Float.isNaN(distance) || Float.isNaN(radius)) {
            return 50.0f;
        }
        float p = radius * radius / distance;
        float q = distance - p;
        float h = FastMath.sqrt((float)(p * q));
        float halfFOVangleRad = FastMath.atan2((float)h, (float)q);
        if (Float.isNaN(halfFOVangleRad)) {
            return 0.87266463f;
        }
        return halfFOVangleRad;
    }

    private float calculateFullFOVangleInDegrees2(float distance, float radius) {
        if (Float.isNaN(distance) || Float.isNaN(radius)) {
            return 50.0f;
        }
        float halfFOVangleRad = this.calculateHalfFOVangleInRadians2(distance, radius);
        float fovdeg = 2.0f * halfFOVangleRad * 57.295776f;
        return fovdeg;
    }

    private float calculateHalfFOVangleInRadians2(float distance, float radius) {
        if (Float.isNaN(distance) || Float.isNaN(radius)) {
            return 50.0f;
        }
        float r_div_d = radius / distance;
        float halfFOVangleRad = FastMath.asin((float)r_div_d);
        if (Float.isNaN(halfFOVangleRad)) {
            return 0.87266463f;
        }
        return halfFOVangleRad;
    }

    @Override
    public void setCameraDistance(final float distance, final boolean correctFOV) {
        if (this.SphereCamDistance == distance && this.doNothingIfEquals) {
            return;
        }
        System.out.println(this.getClass().getSimpleName() + ".setCameraDistance(distance=" + distance + ", correctFOV=" + correctFOV + ")");
        this.SphereCamDistance = distance;
        this.fireChange(ProjectionCalibrator.ProjectionCalibrationValue.SphereCamDistance);
        if (correctFOV) {
            float fov = this.calculateFullFOVangleInDegrees2(distance, this.sphereViewportRadius);
            this.setSpherecameraFieldOfViewAngleAlongYInDegrees(fov, false);
        }
        this.callInRenderThread(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (HyveClientProjectionCalibrator.this.jme3DualViewPortRenderer.sphereScene == null) {
                    System.out.println(Thread.currentThread().toString());
                } else if (HyveClientProjectionCalibrator.this.jme3DualViewPortRenderer.sphereScene.getWorldTranslation() == null) {
                    System.out.println(Thread.currentThread().toString());
                }
                Jme3DualViewPortRenderer jm33DVPR = HyveClientProjectionCalibrator.this.jme3DualViewPortRenderer;
                if (jm33DVPR.sphereScene != null) {
                    Vector3f posSphere = jm33DVPR.sphereScene.getWorldTranslation().clone();
                    posSphere.y += HyveClientProjectionCalibrator.this.SphereCamDistance;
                    HyveClientProjectionCalibrator.this.jme3DualViewPortRenderer.cam.setLocation(posSphere);
                    HyveClientProjectionCalibrator.this.jme3DualViewPortRenderer.cam.lookAt(HyveClientProjectionCalibrator.this.jme3DualViewPortRenderer.sphereScene.getWorldTranslation(), Vector3f.UNIT_Z.mult(-1.0f));
                } else {
                    System.out.println("jm33DVPR.sphereScene was null !!!!!!!!!! for setCameraDistance(distance: " + distance + ", correctFOV: " + correctFOV + ")");
                }
                return null;
            }
        });
    }

    private void callInRenderThread(Callable<Object> c) {
        if (this.jme3DualViewPortRenderer.threadingHelper.isThreadEqualToRenderThread(Thread.currentThread())) {
            try {
                c.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.jme3DualViewPortRenderer.threadingHelper.enqueue(c);
        }
    }

    @Override
    public float getSphereScale() {
        return this.SphereScale;
    }

    @Override
    public void setSphereScale(float scale) {
        if (this.getSphereScale() == scale && this.doNothingIfEquals) {
            return;
        }
        this.SphereScale = scale;
        this.fireChange(ProjectionCalibrator.ProjectionCalibrationValue.SphereScale);
        final Callable<Object> actualCall = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                HyveClientProjectionCalibrator.this.jme3DualViewPortRenderer.sphereScene.setLocalScale(1.0f, HyveClientProjectionCalibrator.this.SphereScale, 1.0f);
                return null;
            }
        };
        this.callInRenderThread(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (HyveClientProjectionCalibrator.this.jme3DualViewPortRenderer.sphereScene != null) {
                    HyveClientProjectionCalibrator.this.callInRenderThread(actualCall);
                } else {
                    System.out.println("sphereScene == null --> scheduling call for later ");
                    TimerTask task = new TimerTask(){

                        @Override
                        public void run() {
                            System.out.println("Task performed on Thread " + Thread.currentThread().getName());
                            HyveClientProjectionCalibrator.this.callInRenderThread(actualCall);
                        }
                    };
                    Timer timer = new Timer("sphereScene setLocalScale Timer");
                    long delay = 2000L;
                    timer.schedule(task, delay);
                }
                return null;
            }
        });
    }

    @Override
    public float getSpherecameraFieldOfViewAngleAlongYInDegrees() {
        return 2.0f * this.halfFOVangleRad * 57.295776f;
    }

    @Override
    public void setSpherecameraFieldOfViewAngleAlongYInDegrees(float fovYDeg) {
        System.out.println(this.getClass().getSimpleName() + ".setSpherecameraFieldOfViewAngleAlongYInDegrees(fovYDeg=" + fovYDeg + ")");
        this.setSpherecameraFieldOfViewAngleAlongYInDegrees(fovYDeg, false);
    }

    @Override
    public void setSpherecameraFieldOfViewAngleAlongYInDegrees(final float fovYDeg, boolean correctDistance) {
        System.out.println(this.getClass().getSimpleName() + ".setSpherecameraFieldOfViewAngleAlongYInDegrees(fovYDeg=" + fovYDeg + ", correctDistance=" + correctDistance + ")");
        this.halfFOVangleRad = 0.5f * fovYDeg * ((float)Math.PI / 180);
        System.out.println("   ... halfFOVangleRad = " + this.halfFOVangleRad + " ...");
        System.out.println("   ... fireChange(ProjectionCalibrationValue.SphereCamFieldOfView); ...");
        this.fireChange(ProjectionCalibrator.ProjectionCalibrationValue.SphereCamFieldOfView);
        if (this.getSpherecameraFieldOfViewAngleAlongYInDegrees() == fovYDeg && this.doNothingIfEquals) {
            return;
        }
        if (correctDistance) {
            float distance = this.calculateDistance(this.halfFOVangleRad, this.sphereViewportRadius);
            this.setCameraDistance(distance, false);
        }
        this.callInRenderThread(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                int w = HyveClientProjectionCalibrator.this.jme3DualViewPortRenderer.windowDimensions.width;
                int h = HyveClientProjectionCalibrator.this.jme3DualViewPortRenderer.windowDimensions.height;
                System.out.println("### setSpherecameraFieldOfViewAngleAlongYInDegrees is attemting to call jme3DualViewPortRenderer.cam.setFrustumPerspective(... params ...)!!!");
                System.out.println("###   w = " + String.valueOf(w) + ", h = " + String.valueOf(h));
                HyveClientProjectionCalibrator.this.jme3DualViewPortRenderer.cam.setFrustumPerspective(fovYDeg, (float)w / (float)h, 0.01f, 10000.0f);
                return null;
            }
        });
    }

    @Override
    public float getViewPortRadius() {
        return this.sphereViewportRadius;
    }

    @Override
    public void setViewPortRadius(float r) {
        if (this.getViewPortRadius() == r && this.doNothingIfEquals) {
            return;
        }
        this.sphereViewportRadius = r;
        this.fireChange(ProjectionCalibrator.ProjectionCalibrationValue.SphereViewportRadius);
        System.out.println(this.getClass().getSimpleName() + ".setViewPortRadius(" + r + ") ...");
        System.out.println("   ... calculating distance with halfFOVangleRad=" + this.halfFOVangleRad + " and sphereViewportRadius=" + this.sphereViewportRadius + " ...");
        float distance = this.calculateDistance(this.halfFOVangleRad, this.sphereViewportRadius);
        System.out.println("   ... distance has been calculated: " + distance);
        System.out.println("   ... setCameraDistanceAndCorrectFOVToFitViewportRadius(" + distance + ")");
        this.setCameraDistanceAndCorrectFOVToFitViewportRadius(distance);
    }

    @Override
    public void registerChangeListener(ProjectionCalibrator.ProjectionCalibrationValueChangeListener l) {
        this.valueChangeListeners.add(l);
    }

    private void fireChange(ProjectionCalibrator.ProjectionCalibrationValue v) {
        for (ProjectionCalibrator.ProjectionCalibrationValueChangeListener pl : this.valueChangeListeners) {
            if (pl == null) continue;
            pl.valueHasChanged(this, v);
        }
    }

    @Override
    public void setFOVandDistanceAreConnected(boolean connected) {
        this.connectFOVandDistance = connected;
        if (this.connectFOVandDistance) {
            this.setCameraDistance(this.SphereCamDistance, true);
        }
    }

    @Override
    public boolean isFOVconnectedToDistance() {
        return this.connectFOVandDistance;
    }
}

