/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.hyveclient;

import com.hybridlab.hyve3d.data.DataModelKey;
import com.hybridlab.hyve3d.data.DataModelObserver;
import com.hybridlab.hyve3d.data.HyveData;
import com.hybridlab.hyve3d.data.domainobjects.HubNodeInfo;
import com.hybridlab.hyve3d.hyve.HyveApplication;
import com.hybridlab.hyve3d.hyve.SessionInfo;
import com.hybridlab.hyve3d.network.interconnection.InterconnectivityDataModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class InterconnectivitySessionObserver
implements DataModelObserver,
PropertyChangeListener {
    private List<HyveData> dataList = new ArrayList<HyveData>();
    private InterconnectivityDataModel dataModel;
    private TextField textfield;
    private SessionList sessionList;
    private HyveApplication app;

    public InterconnectivitySessionObserver(InterconnectivityDataModel interConnectivityDataModel, TextField interConnectivityTextField, SessionList sessionList, HyveApplication app) {
        this.app = app;
        this.textfield = interConnectivityTextField;
        this.dataModel = interConnectivityDataModel;
        this.sessionList = sessionList;
        for (HyveData d : this.dataModel.getEntities()) {
            this.onDataAdded(d.getKey(), d);
        }
        this.dataModel.addObserver(this);
    }

    @Override
    public void onDataAdded(DataModelKey key, HyveData data) {
        this.dataList.add(data);
        data.addPropertyChangeListener(this);
        this.update();
    }

    private void update() {
        Object txt = "";
        ArrayList<SessionInfo> sinfo = new ArrayList<SessionInfo>();
        ArrayList<HyveData> dataListCopy = new ArrayList<HyveData>(this.dataList);
        for (HyveData d : dataListCopy) {
            if (d instanceof HubNodeInfo) {
                HubNodeInfo info = (HubNodeInfo)d;
                Object sn = "";
                for (SessionInfo s : info.getSession()) {
                    sn = (String)sn + "  " + s.toString() + "\n";
                    if (info.getId().equals(this.app.getNetworking().getHubNode().getId()) || s.id.equals(this.app.getLocalSessionId())) continue;
                    sinfo.add(s);
                }
                txt = (String)txt + String.format("Node: %s - %s\n  Sessions\n%s\n", info.getDescriptiveName(), info.getId().toString(), sn);
                continue;
            }
            txt = (String)txt + d.toString() + "\n\n";
        }
        this.setText((String)txt);
        this.setAvailableSessions(sinfo);
    }

    private void setAvailableSessions(List<SessionInfo> sinfo) {
        this.sessionList.setAvailableSessions(sinfo);
    }

    @Override
    public void onDataRemoved(DataModelKey key, HyveData data) {
        data.removePropertyChangeListener(this);
        this.dataList.remove(data);
        this.update();
    }

    private void setText(String txt) {
        this.textfield.setText(txt);
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        System.out.println(arg0);
        this.update();
    }

    public static interface TextField {
        public void setText(String var1);
    }

    public static interface SessionList {
        public void setAvailableSessions(List<SessionInfo> var1);
    }
}

