/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.inputdevice;

import com.hybridlab.hyve3d.inputdevice.InputDevice;
import com.hybridlab.hyve3d.inputdevice.InputListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class InputDeviceManager {
    private static final Logger logger = Logger.getLogger(InputDeviceManager.class.getName());
    private Map<String, DeviceHandler> deviceHandlers = new HashMap<String, DeviceHandler>();

    public void registerDefaultDevices() {
    }

    public void initDefaultDevices() throws Exception {
        for (DeviceHandler d : this.deviceHandlers.values()) {
            try {
                d.device.init();
            }
            catch (Exception e) {
                logger.severe(e.getMessage());
                e.printStackTrace(System.out);
                throw e;
            }
        }
    }

    public void registerDevice(String key, InputDevice device) {
        this.deviceHandlers.put(key, new DeviceHandler(key, device));
    }

    public void registerListener(String key, InputListener listener) {
        if (!this.deviceHandlers.containsKey(key)) {
            logger.warning("Device " + key + " not found");
        } else {
            DeviceHandler dinfo = this.deviceHandlers.get(key);
            dinfo.addListener(listener);
        }
    }

    public void removeListener(InputListener listener) {
        for (DeviceHandler dinfo : this.deviceHandlers.values()) {
            dinfo.removeListener(listener);
        }
    }

    public void removeAll() {
        for (DeviceHandler dinfo : this.deviceHandlers.values()) {
            dinfo.removeAll();
        }
    }

    class DeviceHandler {
        public InputDevice device;
        public String key;

        public DeviceHandler(String key, InputDevice device) {
            this.key = key;
            this.device = device;
        }

        public void removeAll() {
            this.device.removeAll();
            if (this.device.isStarted()) {
                this.device.stop();
                logger.info("device " + this.key + " stopped");
            }
        }

        public void addListener(InputListener listener) {
            this.device.addListener(listener);
            if (!this.device.isStarted()) {
                if (!this.device.start()) {
                    logger.warning("can't start device " + this.key);
                } else {
                    logger.info("device " + this.key + " started");
                }
            }
        }

        public boolean removeListener(InputListener listener) {
            if (this.device.removeListener(listener)) {
                if (!this.device.hasListener() && this.device.isStarted()) {
                    this.device.stop();
                    logger.info("device " + this.key + " stopped");
                }
                return true;
            }
            return false;
        }
    }
}

