/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.discovery;

import com.hybridlab.hyve3d.network.discovery.DiscoveryClientHandleIncomingMessagesThread;
import com.hybridlab.hyve3d.network.discovery.NetworkServiceDiscovererListener;
import com.hybridlab.hyve3d.network.discovery.ServerEntry;
import com.hybridlab.hyve3d.network.messages.ServiceRequestMessage;
import flexjson.JSONSerializer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class DiscoveryClientThread
extends Thread {
    private DatagramSocket socket = null;
    private DatagramPacket outPacket = null;
    private byte[] outBuf = new byte[1024];
    private static final Logger logger = Logger.getLogger(DiscoveryClientThread.class.getName());
    private ArrayList<ServerEntry> availableServices = new ArrayList();
    private int multicastPort = 0;
    private String multicastAddressGroup = "";
    private String serviceId = "";
    private NetworkServiceDiscovererListener callback = null;

    public DiscoveryClientThread(String multicastAddressGroup, int port, String serviceId, NetworkServiceDiscovererListener callback) {
        this.multicastAddressGroup = multicastAddressGroup;
        this.multicastPort = port;
        this.serviceId = serviceId;
        this.callback = callback;
    }

    @Override
    public void interrupt() {
        if (null != this.socket) {
            this.socket.close();
            this.socket = null;
        }
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thread = null;
        try {
            this.availableServices.clear();
            logger.info("DiscoveryClientThread start at " + InetAddress.getLocalHost().getHostAddress());
            this.socket = new DatagramSocket();
            this.socket.setBroadcast(true);
            thread = new DiscoveryClientHandleIncomingMessagesThread(this, this.socket);
            thread.start();
            ServiceRequestMessage request = new ServiceRequestMessage(this.serviceId);
            JSONSerializer serializer = new JSONSerializer();
            String msg = serializer.exclude(new String[]{"*.class"}).serialize((Object)request);
            this.outBuf = msg.getBytes();
            InetAddress address = InetAddress.getByName("255.255.255.255");
            this.outPacket = new DatagramPacket(this.outBuf, this.outBuf.length, address, this.multicastPort);
            if (null != this.socket) {
                this.socket.send(this.outPacket);
            }
            thread.join();
            thread = null;
        }
        catch (IOException ioe) {
            logger.info(ioe.getMessage());
        }
        catch (ThreadDeath td) {
            logger.info(td.getMessage());
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (null != this.socket) {
                this.socket.close();
                this.socket = null;
            }
            if (null != thread) {
                thread.interrupt();
                thread = null;
            }
            if (null != this.callback) {
                this.callback.discoveryFinished(this.availableServices);
            }
            logger.info("DiscoveryClientThread stopped");
        }
    }

    public void addServices(List<ServerEntry> services) {
        this.availableServices.addAll(services);
    }
}

