/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.discovery;

import com.hybridlab.hyve3d.network.discovery.NetworkServiceManager;
import com.hybridlab.hyve3d.network.discovery.ServerEntry;
import com.hybridlab.hyve3d.network.messages.ServiceRequestAnswerMessage;
import com.hybridlab.hyve3d.network.messages.ServiceRequestMessage;
import flexjson.JSONSerializer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.List;
import java.util.logging.Logger;

class DiscoveryServerHandleClientRequestThread
extends Thread {
    private ServiceRequestMessage request;
    private DatagramSocket socket = null;
    private NetworkServiceManager networkManager;
    private InetAddress clientAddress;
    private int port;
    private static final Logger logger = Logger.getLogger(DiscoveryServerHandleClientRequestThread.class.getName());

    DiscoveryServerHandleClientRequestThread(DatagramSocket socket, NetworkServiceManager networkManager, InetAddress clientAddress, int port, ServiceRequestMessage request) {
        this.socket = socket;
        this.networkManager = networkManager;
        this.clientAddress = clientAddress;
        this.port = port;
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<ServerEntry> services = this.networkManager.getServiceForId(this.request.getId());
        if (null != services && services.size() > 0) {
            try {
                logger.info("HandleClientRequest start");
                ServiceRequestAnswerMessage answer = new ServiceRequestAnswerMessage(this.request.getId(), services);
                JSONSerializer serializer = new JSONSerializer();
                String msg = serializer.include(new String[]{"services"}).exclude(new String[]{"*.class"}).exclude(new String[]{"services.id"}).serialize((Object)answer);
                logger.info("send Client Message = " + msg);
                logger.info(String.format("send Client Message to " + this.clientAddress.toString() + " %d", this.port));
                byte[] outBuf = new byte[1024];
                outBuf = msg.getBytes();
                this.socket.send(new DatagramPacket(outBuf, outBuf.length, this.clientAddress, this.port));
            }
            catch (IOException e) {
                logger.info(e.getMessage());
            }
            finally {
                logger.info("HandleClientRequest stopped");
            }
        }
    }
}

