/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.discovery;

import com.hybridlab.hyve3d.network.discovery.DiscoveryServerHandleClientRequestThread;
import com.hybridlab.hyve3d.network.discovery.NetworkServiceManager;
import com.hybridlab.hyve3d.network.messages.ServiceRequestMessage;
import flexjson.JSONDeserializer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.logging.Logger;

public class DiscoveryServerThread
extends Thread {
    private DatagramSocket socket = null;
    private DatagramPacket inPacket = null;
    private byte[] inBuf = new byte[1024];
    private static final Logger logger = Logger.getLogger(DiscoveryServerThread.class.getName());
    private int multicastPort = 6666;
    private String multicastAddressGroup = "224.168.100.2";
    private NetworkServiceManager networkManager = null;

    public DiscoveryServerThread(NetworkServiceManager networkManager, String multicastAddressGroup, int port) {
        this.multicastAddressGroup = multicastAddressGroup;
        this.multicastPort = port;
        this.networkManager = networkManager;
        this.setName(DiscoveryServerThread.class.getSimpleName() + " " + String.valueOf(this.hashCode()));
    }

    @Override
    public void interrupt() {
        if (null != this.socket) {
            this.socket.close();
            this.socket = null;
        }
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            logger.info("DiscoveryServerThread start");
            this.socket = new DatagramSocket(this.multicastPort);
            while (!this.isInterrupted()) {
                this.inPacket = new DatagramPacket(this.inBuf, this.inBuf.length);
                if (null == this.socket) {
                    return;
                }
                this.socket.receive(this.inPacket);
                InetAddress adr = this.inPacket.getAddress();
                String msg = new String(this.inBuf, 0, this.inPacket.getLength());
                logger.info("From " + adr + " Msg : " + msg);
                try {
                    ServiceRequestMessage request = (ServiceRequestMessage)new JSONDeserializer().deserialize(msg, ServiceRequestMessage.class);
                    logger.info("ServiceRequest with id " + request.getId());
                    if (null == request) continue;
                    Thread.sleep(1000L);
                    DiscoveryServerHandleClientRequestThread thread = new DiscoveryServerHandleClientRequestThread(this.socket, this.networkManager, adr, this.inPacket.getPort(), request);
                    thread.start();
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException ioe) {
            logger.info(ioe.getMessage());
        }
        catch (ThreadDeath td) {
            logger.info(td.getMessage());
        }
        finally {
            if (null != this.socket) {
                this.socket.close();
                this.socket = null;
            }
            logger.info("DiscoveryServerThread stopped");
        }
    }
}

