/*
 * Decompiled with CFR 0.152.
 */
package com.hybridlab.hyve3d.network.discovery;

import com.hybridlab.hyve3d.network.discovery.ConnectionStateChangedListener;
import com.hybridlab.hyve3d.network.discovery.DiscoveryClientThread;
import com.hybridlab.hyve3d.network.discovery.NetworkServiceDiscovererListener;
import com.hybridlab.hyve3d.network.discovery.ServerEntry;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkServiceDiscoverer
implements NetworkServiceDiscovererListener {
    public static final String TAG = NetworkServiceDiscoverer.class.getName();
    private NetworkServiceDiscovererListener callback = null;
    private DiscoveryClientThread thread = null;
    private boolean threadIsRunning = false;
    private Object lock = new Object();
    public ArrayList<ConnectionStateChangedListener> connectionListeners = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discover(String serviceId, NetworkServiceDiscovererListener callback) {
        this.stop();
        Object object = this.lock;
        synchronized (object) {
            this.callback = callback;
            this.threadIsRunning = true;
            this.thread = new DiscoveryClientThread("224.168.100.2", 6665, serviceId, this);
            this.thread.start();
        }
    }

    public void addConnectionListener(ConnectionStateChangedListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(ConnectionStateChangedListener listener) {
        this.connectionListeners.remove(listener);
    }

    protected void OnConnectionStateChanged() {
        if (null != this.connectionListeners) {
            for (ConnectionStateChangedListener listener : this.connectionListeners) {
                try {
                    listener.connectionStateChanged();
                }
                catch (Exception e) {
                    Logger.getLogger(TAG).log(Level.SEVERE, e.getMessage());
                }
            }
        }
    }

    public boolean isRunning() {
        return null != this.thread && this.thread.isAlive() && this.threadIsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (null != this.thread) {
                this.thread.interrupt();
                this.thread = null;
            }
            this.threadIsRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discoveryFinished(ArrayList<ServerEntry> availableServices) {
        Object object = this.lock;
        synchronized (object) {
            this.threadIsRunning = false;
        }
        if (null != this.callback) {
            this.callback.discoveryFinished(availableServices);
        }
    }
}

